/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.morphlines.cell;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.io.Closeables;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.handler.extraction.ExtractionDateUtil;
import org.apache.solr.handler.extraction.SolrContentHandler;
import org.apache.solr.handler.extraction.SolrContentHandlerFactory;
import org.apache.solr.morphlines.cell.TrimSolrContentHandlerFactory;
import org.apache.solr.morphlines.solr.SolrLocator;
import org.apache.solr.schema.IndexSchema;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.stdio.AbstractParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class SolrCellBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("solrCell");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new SolrCell(this, config, parent, child, context);
    }

    private static final class SolrCell
    extends AbstractParser {
        private final IndexSchema schema;
        private final List<String> dateFormats;
        private final String xpathExpr;
        private final List<Parser> parsers = new ArrayList<Parser>();
        private final SolrContentHandlerFactory solrContentHandlerFactory;
        private final Locale locale;
        private final SolrParams solrParams;
        private final Map<MediaType, Parser> mediaTypeToParserMap;
        private static final XPathParser PARSER = new XPathParser("xhtml", "http://www.w3.org/1999/xhtml");
        public static final String ADDITIONAL_SUPPORTED_MIME_TYPES = "additionalSupportedMimeTypes";

        public SolrCell(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            Class<SolrContentHandlerFactory> factoryClass;
            String defaultField;
            String lowerNames;
            String captureAttributes;
            Config solrLocatorConfig = this.getConfigs().getConfig(config, "solrLocator");
            SolrLocator locator = new SolrLocator(solrLocatorConfig, context);
            this.LOG.debug("solrLocator: {}", (Object)locator);
            this.schema = Objects.requireNonNull(locator.getIndexSchema());
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace("Solr schema: \n" + this.schema.getFields().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(Object::toString).collect(Collectors.joining("\n")));
            }
            ArrayListMultimap cellParams = ArrayListMultimap.create();
            String uprefix = this.getConfigs().getString(config, "uprefix", null);
            if (uprefix != null) {
                cellParams.put((Object)"uprefix", (Object)uprefix);
            }
            for (Object capture : this.getConfigs().getStringList(config, "capture", Collections.emptyList())) {
                cellParams.put((Object)"capture", capture);
            }
            Config fmapConfig = this.getConfigs().getConfig(config, "fmap", null);
            if (fmapConfig != null) {
                for (Map.Entry entry : new Configs().getEntrySet(fmapConfig)) {
                    cellParams.put((Object)("fmap." + (String)entry.getKey()), (Object)entry.getValue().toString());
                }
            }
            if ((captureAttributes = this.getConfigs().getString(config, "captureAttr", null)) != null) {
                cellParams.put((Object)"captureAttr", (Object)captureAttributes);
            }
            if ((lowerNames = this.getConfigs().getString(config, "lowernames", null)) != null) {
                cellParams.put((Object)"lowernames", (Object)lowerNames);
            }
            if ((defaultField = this.getConfigs().getString(config, "defaultField", null)) != null) {
                cellParams.put((Object)"defaultField", (Object)defaultField);
            }
            this.xpathExpr = this.getConfigs().getString(config, "xpath", null);
            if (this.xpathExpr != null) {
                cellParams.put((Object)"xpath", (Object)this.xpathExpr);
            }
            this.dateFormats = this.getConfigs().getStringList(config, "dateFormats", new ArrayList(ExtractionDateUtil.DEFAULT_DATE_FORMATS));
            String handlerStr = this.getConfigs().getString(config, "solrContentHandlerFactory", TrimSolrContentHandlerFactory.class.getName());
            try {
                factoryClass = Class.forName(handlerStr).asSubclass(SolrContentHandlerFactory.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new MorphlineCompilationException("Could not find class " + handlerStr + " to use for " + "solrContentHandlerFactory", config, (Throwable)cnfe);
            }
            this.solrContentHandlerFactory = SolrCell.getSolrContentHandlerFactory(factoryClass, this.dateFormats, config);
            this.locale = this.getLocale(this.getConfigs().getString(config, "locale", null));
            this.mediaTypeToParserMap = new HashMap<MediaType, Parser>();
            List parserConfigs = this.getConfigs().getConfigList(config, "parsers");
            for (Config parserConfig : parserConfigs) {
                Object obj;
                String parserClassName = this.getConfigs().getString(parserConfig, "parser");
                try {
                    obj = Class.forName(parserClassName).newInstance();
                }
                catch (Throwable e) {
                    throw new MorphlineCompilationException("Cannot instantiate Tika parser: " + parserClassName, config, e);
                }
                if (!(obj instanceof Parser)) {
                    throw new MorphlineCompilationException("Tika parser " + obj.getClass().getName() + " must be an instance of class " + Parser.class.getName(), config);
                }
                Parser parser = (Parser)obj;
                this.parsers.add(parser);
                List mediaTypes = this.getConfigs().getStringList(parserConfig, "supportedMimeTypes", Collections.emptyList());
                for (String mediaTypeStr : mediaTypes) {
                    MediaType mediaType = this.parseMediaType(mediaTypeStr);
                    this.addSupportedMimeType(mediaTypeStr);
                    this.mediaTypeToParserMap.put(mediaType, parser);
                }
                if (parserConfig.hasPath("supportedMimeTypes")) continue;
                for (MediaType mediaType : parser.getSupportedTypes(new ParseContext())) {
                    mediaType = mediaType.getBaseType();
                    this.addSupportedMimeType(mediaType.toString());
                    this.mediaTypeToParserMap.put(mediaType, parser);
                }
                List extras = this.getConfigs().getStringList(parserConfig, ADDITIONAL_SUPPORTED_MIME_TYPES, Collections.emptyList());
                for (String mediaTypeStr : extras) {
                    MediaType mediaType = this.parseMediaType(mediaTypeStr);
                    this.addSupportedMimeType(mediaTypeStr);
                    this.mediaTypeToParserMap.put(mediaType, parser);
                }
            }
            HashMap tmp = new HashMap();
            for (Map.Entry entry : cellParams.asMap().entrySet()) {
                tmp.put(entry.getKey(), ((Collection)entry.getValue()).toArray(new String[((Collection)entry.getValue()).size()]));
            }
            this.solrParams = new MultiMapSolrParams(tmp);
            this.validateArguments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doProcess(Record record, InputStream inputStream) {
            Parser parser = this.detectParser(record);
            if (parser == null) {
                return false;
            }
            ParseContext parseContext = new ParseContext();
            parseContext.set(Locale.class, (Object)this.locale);
            Metadata metadata = new Metadata();
            for (Map.Entry entry : record.getFields().entries()) {
                metadata.add((String)entry.getKey(), entry.getValue().toString());
            }
            SolrContentHandler handler = this.solrContentHandlerFactory.createSolrContentHandler(metadata, this.solrParams, this.schema);
            try {
                inputStream = TikaInputStream.get((InputStream)inputStream);
                SolrContentHandler parsingHandler = handler;
                if (this.xpathExpr != null) {
                    Matcher matcher = PARSER.parse(this.xpathExpr);
                    parsingHandler = new MatchingContentHandler((ContentHandler)parsingHandler, matcher);
                }
                try {
                    parser.parse(inputStream, (ContentHandler)parsingHandler, metadata, parseContext);
                }
                catch (IOException | TikaException | SAXException e) {
                    throw new MorphlineRuntimeException("Cannot parse", e);
                }
            }
            finally {
                if (inputStream != null) {
                    Closeables.closeQuietly((Closeable)inputStream);
                }
            }
            SolrInputDocument doc = handler.newDocument();
            this.LOG.debug("solr doc: {}", (Object)doc);
            Record outputRecord = this.toRecord(doc);
            return this.getChild().process(outputRecord);
        }

        private Parser detectParser(Record record) {
            if (!this.hasAtLeastOneMimeType(record)) {
                return null;
            }
            String mediaTypeStr = (String)record.getFirstValue("_attachment_mimetype");
            assert (mediaTypeStr != null);
            MediaType mediaType = this.parseMediaType(mediaTypeStr).getBaseType();
            Parser parser = this.mediaTypeToParserMap.get(mediaType);
            if (parser != null) {
                return parser;
            }
            for (Map.Entry<MediaType, Parser> entry : this.mediaTypeToParserMap.entrySet()) {
                if (!this.isMediaTypeMatch(mediaType, entry.getKey())) continue;
                return entry.getValue();
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("No supported MIME type parser found for _attachment_mimetype=" + mediaTypeStr);
            }
            return null;
        }

        private boolean hasAtLeastOneMimeType(Record record) {
            if (!record.getFields().containsKey((Object)"_attachment_mimetype")) {
                this.LOG.debug("Command failed because of missing MIME type for record: {}", (Object)record);
                return false;
            }
            return true;
        }

        private MediaType parseMediaType(String mediaTypeStr) {
            MediaType mediaType = MediaType.parse((String)mediaTypeStr.trim().toLowerCase(Locale.ROOT));
            return mediaType.getBaseType();
        }

        private boolean isMediaTypeMatch(MediaType mediaType, MediaType rangePattern) {
            String WILDCARD = "*";
            String rangePatternType = rangePattern.getType();
            String rangePatternSubtype = rangePattern.getSubtype();
            return !(!rangePatternType.equals(WILDCARD) && !rangePatternType.equals(mediaType.getType()) || !rangePatternSubtype.equals(WILDCARD) && !rangePatternSubtype.equals(mediaType.getSubtype()));
        }

        private static SolrContentHandlerFactory getSolrContentHandlerFactory(Class<? extends SolrContentHandlerFactory> factoryClass, Collection<String> dateFormats, Config config) {
            try {
                return factoryClass.getConstructor(Collection.class).newInstance(dateFormats);
            }
            catch (NoSuchMethodException nsme) {
                throw new MorphlineCompilationException("Unable to find valid constructor of type " + factoryClass.getName() + " for creating SolrContentHandler", config, (Throwable)nsme);
            }
            catch (Exception e) {
                throw new MorphlineCompilationException("Unexpected exception when trying to create SolrContentHandlerFactory of type " + factoryClass.getName(), config, (Throwable)e);
            }
        }

        private Record toRecord(SolrInputDocument doc) {
            Record record = new Record();
            for (Map.Entry entry : doc.entrySet()) {
                record.getFields().putAll(entry.getKey(), (Iterable)((SolrInputField)entry.getValue()).getValues());
            }
            return record;
        }

        @SuppressForbidden(reason="Usage of outdated locale parsing with Locale#toString() because of backwards compatibility")
        private Locale getLocale(String name) {
            if (name == null) {
                return Locale.ROOT;
            }
            for (Locale locale : Locale.getAvailableLocales()) {
                if (!locale.toString().equals(name)) continue;
                return locale;
            }
            try {
                return new Locale.Builder().setLanguageTag(name).build();
            }
            catch (IllformedLocaleException ex) {
                throw new MorphlineCompilationException("Malformed / non-existent locale: " + name, this.getConfig(), (Throwable)ex);
            }
        }
    }
}

