/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.ltr.model.ModelException;
import org.apache.solr.ltr.norm.IdentityNormalizer;
import org.apache.solr.ltr.norm.Normalizer;
import org.apache.solr.util.SolrPluginUtils;

public abstract class LTRScoringModel {
    protected final String name;
    private final String featureStoreName;
    protected final List<Feature> features;
    private final List<Feature> allFeatures;
    private final Map<String, Object> params;
    protected final List<Normalizer> norms;

    public static LTRScoringModel getInstance(SolrResourceLoader solrResourceLoader, String className, String name, List<Feature> features, List<Normalizer> norms, String featureStoreName, List<Feature> allFeatures, Map<String, Object> params) throws ModelException {
        LTRScoringModel model;
        try {
            model = (LTRScoringModel)solrResourceLoader.newInstance(className, LTRScoringModel.class, new String[0], new Class[]{String.class, List.class, List.class, String.class, List.class, Map.class}, new Object[]{name, features, norms, featureStoreName, allFeatures, params});
            if (params != null) {
                SolrPluginUtils.invokeSetters((Object)model, params.entrySet());
            }
        }
        catch (Exception e) {
            throw new ModelException("Model type does not exist " + className, e);
        }
        model.validate();
        return model;
    }

    public LTRScoringModel(String name, List<Feature> features, List<Normalizer> norms, String featureStoreName, List<Feature> allFeatures, Map<String, Object> params) {
        this.name = name;
        this.features = features;
        this.featureStoreName = featureStoreName;
        this.allFeatures = allFeatures;
        this.params = params;
        this.norms = norms;
    }

    protected void validate() throws ModelException {
        List<Feature> features = this.getFeatures();
        List<Normalizer> norms = this.getNorms();
        if (features.isEmpty()) {
            throw new ModelException("no features declared for model " + this.name);
        }
        HashSet<String> featureNames = new HashSet<String>();
        for (Feature feature : features) {
            String featureName = feature.getName();
            if (featureNames.add(featureName)) continue;
            throw new ModelException("duplicated feature " + featureName + " in model " + this.name);
        }
        if (features.size() != norms.size()) {
            throw new ModelException("counted " + features.size() + " features and " + norms.size() + " norms in model " + this.name);
        }
    }

    public List<Normalizer> getNorms() {
        return Collections.unmodifiableList(this.norms);
    }

    public String getName() {
        return this.name;
    }

    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.norms == null ? 0 : this.norms.hashCode());
        result = 31 * result + (this.featureStoreName == null ? 0 : this.featureStoreName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LTRScoringModel other = (LTRScoringModel)obj;
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (this.norms == null ? other.norms != null : !this.norms.equals(other.norms)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        return !(this.featureStoreName == null ? other.featureStoreName != null : !this.featureStoreName.equals(other.featureStoreName));
    }

    public boolean hasParams() {
        return this.params != null && !this.params.isEmpty();
    }

    public Collection<Feature> getAllFeatures() {
        return this.allFeatures;
    }

    public String getFeatureStoreName() {
        return this.featureStoreName;
    }

    public abstract float score(float[] var1);

    public abstract Explanation explain(LeafReaderContext var1, int var2, float var3, List<Explanation> var4);

    public String toString() {
        return this.getClass().getSimpleName() + "(name=" + this.getName() + ")";
    }

    public void normalizeFeaturesInPlace(float[] modelFeatureValues) {
        float[] modelFeatureValuesNormalized = modelFeatureValues;
        if (modelFeatureValues.length != this.norms.size()) {
            throw new FeatureException("Must have normalizer for every feature");
        }
        for (int idx = 0; idx < modelFeatureValuesNormalized.length; ++idx) {
            modelFeatureValuesNormalized[idx] = this.norms.get(idx).normalize(modelFeatureValuesNormalized[idx]);
        }
    }

    public Explanation getNormalizerExplanation(Explanation e, int idx) {
        Normalizer n = this.norms.get(idx);
        if (n != IdentityNormalizer.INSTANCE) {
            return n.explain(e);
        }
        return e;
    }
}

