/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.response.transform;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.ltr.CSVFeatureLogger;
import org.apache.solr.ltr.FeatureLogger;
import org.apache.solr.ltr.LTRRescorer;
import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.ltr.LTRThreadModule;
import org.apache.solr.ltr.SolrQueryRequestContextUtils;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.model.LTRScoringModel;
import org.apache.solr.ltr.norm.Normalizer;
import org.apache.solr.ltr.search.LTRQParserPlugin;
import org.apache.solr.ltr.store.FeatureStore;
import org.apache.solr.ltr.store.rest.ManagedFeatureStore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRFeatureLoggerTransformerFactory
extends TransformerFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String FV_FORMAT = "format";
    private static final String FV_STORE = "store";
    private static String DEFAULT_LOGGING_MODEL_NAME = "logging-model";
    private String fvCacheName;
    private String loggingModelName = DEFAULT_LOGGING_MODEL_NAME;
    private String defaultStore;
    private FeatureLogger.FeatureFormat defaultFormat = FeatureLogger.FeatureFormat.DENSE;
    private char csvKeyValueDelimiter = (char)61;
    private char csvFeatureSeparator = (char)44;
    private LTRThreadModule threadManager = null;

    public void setFvCacheName(String fvCacheName) {
        this.fvCacheName = fvCacheName;
    }

    public void setLoggingModelName(String loggingModelName) {
        this.loggingModelName = loggingModelName;
    }

    public void setDefaultStore(String defaultStore) {
        this.defaultStore = defaultStore;
    }

    public void setDefaultFormat(String defaultFormat) {
        this.defaultFormat = FeatureLogger.FeatureFormat.valueOf(defaultFormat.toUpperCase(Locale.ROOT));
    }

    public void setCsvKeyValueDelimiter(String csvKeyValueDelimiter) {
        if (csvKeyValueDelimiter.length() != 1) {
            throw new IllegalArgumentException("csvKeyValueDelimiter must be exactly 1 character");
        }
        this.csvKeyValueDelimiter = csvKeyValueDelimiter.charAt(0);
    }

    public void setCsvFeatureSeparator(String csvFeatureSeparator) {
        if (csvFeatureSeparator.length() != 1) {
            throw new IllegalArgumentException("csvFeatureSeparator must be exactly 1 character");
        }
        this.csvFeatureSeparator = csvFeatureSeparator.charAt(0);
    }

    public void init(NamedList args) {
        super.init(args);
        this.threadManager = LTRThreadModule.getInstance(args);
        SolrPluginUtils.invokeSetters((Object)((Object)this), (Iterable)args);
    }

    public DocTransformer create(String name, SolrParams localparams, SolrQueryRequest req) {
        SolrQueryRequestContextUtils.setIsExtractingFeatures(req);
        SolrQueryRequestContextUtils.setFvStoreName(req, localparams.get(FV_STORE, this.defaultStore));
        SolrQueryRequestContextUtils.setFeatureLogger(req, this.createFeatureLogger(localparams.get(FV_FORMAT)));
        return new FeatureTransformer(name, localparams, req);
    }

    private FeatureLogger createFeatureLogger(String formatStr) {
        FeatureLogger.FeatureFormat format = formatStr != null ? FeatureLogger.FeatureFormat.valueOf(formatStr.toUpperCase(Locale.ROOT)) : this.defaultFormat;
        if (this.fvCacheName == null) {
            throw new IllegalArgumentException("a fvCacheName must be configured");
        }
        return new CSVFeatureLogger(this.fvCacheName, format, this.csvKeyValueDelimiter, this.csvFeatureSeparator);
    }

    private static class LoggingModel
    extends LTRScoringModel {
        public LoggingModel(String name, String featureStoreName, List<Feature> allFeatures) {
            this(name, Collections.emptyList(), Collections.emptyList(), featureStoreName, allFeatures, Collections.emptyMap());
        }

        protected LoggingModel(String name, List<Feature> features, List<Normalizer> norms, String featureStoreName, List<Feature> allFeatures, Map<String, Object> params) {
            super(name, features, norms, featureStoreName, allFeatures, params);
        }

        @Override
        public float score(float[] modelFeatureValuesNormalized) {
            return 0.0f;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc, float finalScore, List<Explanation> featureExplanations) {
            return Explanation.match((float)finalScore, (String)(this.toString() + " logging model, used only for logging the features"), (Explanation[])new Explanation[0]);
        }
    }

    class FeatureTransformer
    extends DocTransformer {
        private final String name;
        private final SolrParams localparams;
        private final SolrQueryRequest req;
        private List<LeafReaderContext> leafContexts;
        private SolrIndexSearcher searcher;
        private LTRScoringQuery scoringQuery;
        private LTRScoringQuery.ModelWeight modelWeight;
        private FeatureLogger featureLogger;
        private boolean docsWereNotReranked;

        public FeatureTransformer(String name, SolrParams localparams, SolrQueryRequest req) {
            this.name = name;
            this.localparams = localparams;
            this.req = req;
        }

        public String getName() {
            return this.name;
        }

        public void setContext(ResultContext context) {
            super.setContext(context);
            if (context == null) {
                return;
            }
            if (context.getRequest() == null) {
                return;
            }
            this.searcher = context.getSearcher();
            if (this.searcher == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "searcher is null");
            }
            this.leafContexts = this.searcher.getTopReaderContext().leaves();
            this.scoringQuery = SolrQueryRequestContextUtils.getScoringQuery(this.req);
            this.docsWereNotReranked = this.scoringQuery == null;
            String featureStoreName = SolrQueryRequestContextUtils.getFvStoreName(this.req);
            if (this.docsWereNotReranked || featureStoreName != null && !featureStoreName.equals(this.scoringQuery.getScoringModel().getFeatureStoreName())) {
                ManagedFeatureStore fr = ManagedFeatureStore.getManagedFeatureStore(this.req.getCore());
                FeatureStore store = fr.getFeatureStore(featureStoreName);
                featureStoreName = store.getName();
                try {
                    LoggingModel lm = new LoggingModel(LTRFeatureLoggerTransformerFactory.this.loggingModelName, featureStoreName, store.getFeatures());
                    this.scoringQuery = new LTRScoringQuery(lm, LTRQParserPlugin.extractEFIParams(this.localparams), true, LTRFeatureLoggerTransformerFactory.this.threadManager);
                    this.scoringQuery.setOriginalQuery(context.getQuery());
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "retrieving the feature store " + featureStoreName, (Throwable)e);
                }
            }
            if (this.scoringQuery.getFeatureLogger() == null) {
                this.scoringQuery.setFeatureLogger(SolrQueryRequestContextUtils.getFeatureLogger(this.req));
            }
            this.scoringQuery.setRequest(this.req);
            this.featureLogger = this.scoringQuery.getFeatureLogger();
            try {
                this.modelWeight = this.scoringQuery.createWeight((IndexSearcher)this.searcher, true);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
            }
            if (this.modelWeight == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "error logging the features, model weight is null");
            }
        }

        public void transform(SolrDocument doc, int docid, float score) throws IOException {
            String fv = this.featureLogger.getFeatureVector(docid, this.scoringQuery, this.searcher);
            if (fv == null) {
                fv = this.featureLogger.makeFeatureVector(LTRRescorer.extractFeaturesInfo(this.modelWeight, docid, this.docsWereNotReranked ? new Float(score) : null, this.leafContexts));
            }
            doc.addField(this.name, (Object)fv);
        }
    }
}

