/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.search;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Rescorer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.LTRRescorer;
import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.ltr.LTRThreadModule;
import org.apache.solr.ltr.SolrQueryRequestContextUtils;
import org.apache.solr.ltr.model.LTRScoringModel;
import org.apache.solr.ltr.store.rest.ManagedFeatureStore;
import org.apache.solr.ltr.store.rest.ManagedModelStore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceObserver;
import org.apache.solr.search.AbstractReRankQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRQParserPlugin
extends QParserPlugin
implements ResourceLoaderAware,
ManagedResourceObserver {
    public static final String NAME = "ltr";
    private static Query defaultQuery = new MatchAllDocsQuery();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String EXTERNAL_FEATURE_INFO = "efi.";
    private ManagedFeatureStore fr = null;
    private ManagedModelStore mr = null;
    private LTRThreadModule threadManager = null;
    public static final String MODEL = "model";
    public static final int DEFAULT_RERANK_DOCS = 200;
    public static final String RERANK_DOCS = "reRankDocs";

    public void init(NamedList args) {
        super.init(args);
        this.threadManager = LTRThreadModule.getInstance(args);
        SolrPluginUtils.invokeSetters((Object)((Object)this), (Iterable)args);
    }

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new LTRQParser(qstr, localParams, params, req);
    }

    public static Map<String, String[]> extractEFIParams(SolrParams localParams) {
        HashMap<String, String[]> externalFeatureInfo = new HashMap<String, String[]>();
        Iterator it = localParams.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.startsWith(EXTERNAL_FEATURE_INFO)) continue;
            externalFeatureInfo.put(name.substring(EXTERNAL_FEATURE_INFO.length()), new String[]{localParams.get(name)});
        }
        return externalFeatureInfo;
    }

    public void inform(ResourceLoader loader) throws IOException {
        SolrResourceLoader solrResourceLoader = (SolrResourceLoader)loader;
        ManagedFeatureStore.registerManagedFeatureStore(solrResourceLoader, this);
        ManagedModelStore.registerManagedModelStore(solrResourceLoader, this);
    }

    public void onManagedResourceInitialized(NamedList<?> args, ManagedResource res) throws SolrException {
        if (res instanceof ManagedFeatureStore) {
            this.fr = (ManagedFeatureStore)res;
        }
        if (res instanceof ManagedModelStore) {
            this.mr = (ManagedModelStore)res;
        }
        if (this.mr != null && this.fr != null) {
            this.mr.setManagedFeatureStore(this.fr);
            this.mr.loadStoredModels();
        }
    }

    public class LTRQuery
    extends AbstractReRankQuery {
        private final LTRScoringQuery scoringQuery;

        public LTRQuery(LTRScoringQuery scoringQuery, int reRankDocs) {
            super(defaultQuery, reRankDocs, (Rescorer)new LTRRescorer(scoringQuery));
            this.scoringQuery = scoringQuery;
        }

        public int hashCode() {
            return 31 * this.classHash() + (this.mainQuery.hashCode() + this.scoringQuery.hashCode() + this.reRankDocs);
        }

        public boolean equals(Object o) {
            return this.sameClassAs(o) && this.equalsTo((LTRQuery)((Object)((Object)((Object)this)).getClass().cast(o)));
        }

        private boolean equalsTo(LTRQuery other) {
            return this.mainQuery.equals((Object)other.mainQuery) && this.scoringQuery.equals((Object)other.scoringQuery) && this.reRankDocs == other.reRankDocs;
        }

        public RankQuery wrap(Query _mainQuery) {
            super.wrap(_mainQuery);
            this.scoringQuery.setOriginalQuery(_mainQuery);
            return this;
        }

        public String toString(String field) {
            return "{!ltr mainQuery='" + this.mainQuery.toString() + "' scoringQuery='" + this.scoringQuery.toString() + "' reRankDocs=" + this.reRankDocs + "}";
        }

        protected Query rewrite(Query rewrittenMainQuery) throws IOException {
            return new LTRQuery(this.scoringQuery, this.reRankDocs).wrap(rewrittenMainQuery);
        }
    }

    public class LTRQParser
    extends QParser {
        public LTRQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        public Query parse() throws SyntaxError {
            String modelName = this.localParams.get(LTRQParserPlugin.MODEL);
            if (modelName == null || modelName.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Must provide model in the request");
            }
            LTRScoringModel ltrScoringModel = LTRQParserPlugin.this.mr.getModel(modelName);
            if (ltrScoringModel == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "cannot find model " + modelName);
            }
            String modelFeatureStoreName = ltrScoringModel.getFeatureStoreName();
            boolean extractFeatures = SolrQueryRequestContextUtils.isExtractingFeatures(this.req);
            String fvStoreName = SolrQueryRequestContextUtils.getFvStoreName(this.req);
            boolean featuresRequestedFromSameStore = modelFeatureStoreName.equals(fvStoreName) || fvStoreName == null ? extractFeatures : false;
            LTRScoringQuery scoringQuery = new LTRScoringQuery(ltrScoringModel, LTRQParserPlugin.extractEFIParams(this.localParams), featuresRequestedFromSameStore, LTRQParserPlugin.this.threadManager);
            if (featuresRequestedFromSameStore) {
                scoringQuery.setFeatureLogger(SolrQueryRequestContextUtils.getFeatureLogger(this.req));
            }
            SolrQueryRequestContextUtils.setScoringQuery(this.req, scoringQuery);
            int reRankDocs = this.localParams.getInt(LTRQParserPlugin.RERANK_DOCS, 200);
            if (reRankDocs <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Must rerank at least 1 document");
            }
            scoringQuery.setRequest(this.req);
            return new LTRQuery(scoringQuery, reRankDocs);
        }
    }
}

