/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class SolrFeature
extends Feature {
    private String df;
    private String q;
    private List<String> fq;

    public String getDf() {
        return this.df;
    }

    public void setDf(String df) {
        this.df = df;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public List<String> getFq() {
        return this.fq;
    }

    public void setFq(List<String> fq) {
        this.fq = fq;
    }

    public SolrFeature(String name, Map<String, Object> params) {
        super(name, params);
    }

    @Override
    public LinkedHashMap<String, Object> paramsToMap() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(3, 1.0f);
        if (this.df != null) {
            params.put("df", this.df);
        }
        if (this.q != null) {
            params.put("q", this.q);
        }
        if (this.fq != null) {
            params.put("fq", this.fq);
        }
        return params;
    }

    @Override
    public Feature.FeatureWeight createWeight(IndexSearcher searcher, boolean needsScores, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
        return new SolrFeatureWeight(searcher, request, originalQuery, efi);
    }

    @Override
    protected void validate() throws FeatureException {
        if ((this.q == null || this.q.isEmpty()) && (this.fq == null || this.fq.isEmpty())) {
            throw new FeatureException(((Object)((Object)this)).getClass().getSimpleName() + ": Q or FQ must be provided");
        }
    }

    public class SolrFeatureWeight
    extends Feature.FeatureWeight {
        private final Weight solrQueryWeight;
        private final Query query;
        private final List<Query> queryAndFilters;

        public SolrFeatureWeight(IndexSearcher searcher, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
            super(SolrFeature.this, searcher, request, originalQuery, efi);
            try {
                String solrQuery = SolrFeature.this.q;
                List fqs = SolrFeature.this.fq;
                if (solrQuery == null || solrQuery.isEmpty()) {
                    solrQuery = "*:*";
                }
                if ((solrQuery = this.macroExpander.expand(solrQuery)) == null) {
                    throw new FeatureException(((Object)((Object)this)).getClass().getSimpleName() + " requires efi parameter that was not passed in request.");
                }
                LocalSolrQueryRequest req = this.makeRequest(request.getCore(), solrQuery, fqs, SolrFeature.this.df);
                if (req == null) {
                    throw new IOException("ERROR: No parameters provided");
                }
                this.queryAndFilters = new ArrayList<Query>();
                if (fqs != null) {
                    for (String fq : fqs) {
                        QParser fqp;
                        Query filterQuery;
                        if (fq == null || fq.trim().length() == 0 || (filterQuery = (fqp = QParser.getParser((String)(fq = this.macroExpander.expand(fq)), (SolrQueryRequest)req)).getQuery()) == null) continue;
                        this.queryAndFilters.add(filterQuery);
                    }
                }
                QParser parser = QParser.getParser((String)solrQuery, (SolrQueryRequest)req);
                this.query = parser.parse();
                if (this.query != null) {
                    this.queryAndFilters.add(this.query);
                    this.solrQueryWeight = searcher.createNormalizedWeight(this.query, true);
                } else {
                    this.solrQueryWeight = null;
                }
            }
            catch (SyntaxError e) {
                throw new FeatureException("Failed to parse feature query.", (Exception)((Object)e));
            }
        }

        private LocalSolrQueryRequest makeRequest(SolrCore core, String solrQuery, List<String> fqs, String df) {
            NamedList returnList = new NamedList();
            if (solrQuery != null && !solrQuery.isEmpty()) {
                returnList.add("q", (Object)solrQuery);
            }
            if (fqs != null) {
                for (String fq : fqs) {
                    returnList.add("fq", (Object)fq);
                }
            }
            if (df != null && !df.isEmpty()) {
                returnList.add("df", (Object)df);
            }
            if (returnList.size() > 0) {
                return new LocalSolrQueryRequest(core, returnList);
            }
            return null;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            if (this.solrQueryWeight != null) {
                this.solrQueryWeight.extractTerms(terms);
            }
        }

        public float getValueForNormalization() throws IOException {
            if (this.solrQueryWeight != null) {
                return this.solrQueryWeight.getValueForNormalization();
            }
            return 0.0f;
        }

        public void normalize(float norm, float boost) {
            if (this.solrQueryWeight != null) {
                this.solrQueryWeight.normalize(norm, boost);
            }
        }

        @Override
        public Feature.FeatureWeight.FeatureScorer scorer(LeafReaderContext context) throws IOException {
            DocIdSetIterator idItr;
            Scorer solrScorer = null;
            if (this.solrQueryWeight != null) {
                solrScorer = this.solrQueryWeight.scorer(context);
            }
            if ((idItr = this.getDocIdSetIteratorFromQueries(this.queryAndFilters, context)) != null) {
                return solrScorer == null ? new Feature.FeatureWeight.ValueFeatureScorer(this, 1.0f, idItr) : new SolrFeatureScorer(this, solrScorer, new SolrFeatureScorerIterator(idItr, solrScorer.iterator()));
            }
            return null;
        }

        private DocIdSetIterator getDocIdSetIteratorFromQueries(List<Query> queries, LeafReaderContext context) throws IOException {
            DocIdSet idSet;
            SolrIndexSearcher.ProcessedFilter pf = ((SolrIndexSearcher)this.searcher).getProcessedFilter(null, queries);
            Bits liveDocs = context.reader().getLiveDocs();
            DocIdSetIterator idIter = null;
            if (pf.filter != null && (idSet = pf.filter.getDocIdSet(context, liveDocs)) != null) {
                idIter = idSet.iterator();
            }
            return idIter;
        }

        public class SolrFeatureScorerIterator
        extends DocIdSetIterator {
            private final DocIdSetIterator filterIterator;
            private final DocIdSetIterator scorerFilter;

            SolrFeatureScorerIterator(DocIdSetIterator filterIterator, DocIdSetIterator scorerFilter) {
                this.filterIterator = filterIterator;
                this.scorerFilter = scorerFilter;
            }

            public int docID() {
                return this.filterIterator.docID();
            }

            public int nextDoc() throws IOException {
                int docID = this.filterIterator.nextDoc();
                this.scorerFilter.advance(docID);
                return docID;
            }

            public int advance(int target) throws IOException {
                int docID = this.filterIterator.advance(target);
                this.scorerFilter.advance(docID);
                return docID;
            }

            public long cost() {
                return this.filterIterator.cost() + this.scorerFilter.cost();
            }
        }

        public class SolrFeatureScorer
        extends Feature.FeatureWeight.FeatureScorer {
            private final Scorer solrScorer;

            public SolrFeatureScorer(Feature.FeatureWeight weight, Scorer solrScorer, SolrFeatureScorerIterator itr) {
                super(weight, itr);
                this.solrScorer = solrScorer;
            }

            @Override
            public float score() throws IOException {
                try {
                    return this.solrScorer.score();
                }
                catch (UnsupportedOperationException e) {
                    throw new FeatureException(e.toString() + ": Unable to extract feature for " + this.name, e);
                }
            }
        }
    }
}

