/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.feature;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.ltr.DocInfo;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.request.SolrQueryRequest;

public class OriginalScoreFeature
extends Feature {
    public OriginalScoreFeature(String name, Map<String, Object> params) {
        super(name, params);
    }

    @Override
    public LinkedHashMap<String, Object> paramsToMap() {
        return null;
    }

    @Override
    protected void validate() throws FeatureException {
    }

    @Override
    public OriginalScoreWeight createWeight(IndexSearcher searcher, boolean needsScores, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
        return new OriginalScoreWeight(searcher, request, originalQuery, efi);
    }

    public class OriginalScoreWeight
    extends Feature.FeatureWeight {
        final Weight w;

        public OriginalScoreWeight(IndexSearcher searcher, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) throws IOException {
            super(OriginalScoreFeature.this, searcher, request, originalQuery, efi);
            this.w = searcher.createNormalizedWeight(originalQuery, true);
        }

        @Override
        public String toString() {
            return "OriginalScoreFeature [query:" + this.originalQuery.toString() + "]";
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.w.extractTerms(terms);
        }

        public float getValueForNormalization() throws IOException {
            return this.w.getValueForNormalization();
        }

        public void normalize(float norm, float boost) {
            this.w.normalize(norm, boost);
        }

        @Override
        public Feature.FeatureWeight.FeatureScorer scorer(LeafReaderContext context) throws IOException {
            Scorer originalScorer = this.w.scorer(context);
            return new OriginalScoreScorer((Feature.FeatureWeight)this, originalScorer);
        }

        public class OriginalScoreScorer
        extends Feature.FeatureWeight.FeatureScorer {
            private final Scorer originalScorer;

            public OriginalScoreScorer(Feature.FeatureWeight weight, Scorer originalScorer) {
                super(weight, null);
                this.originalScorer = originalScorer;
            }

            @Override
            public float score() throws IOException {
                DocInfo docInfo = this.getDocInfo();
                return docInfo.hasOriginalDocScore() ? docInfo.getOriginalDocScore().floatValue() : this.originalScorer.score();
            }

            @Override
            public int freq() throws IOException {
                return this.originalScorer.freq();
            }

            @Override
            public int docID() {
                return this.originalScorer.docID();
            }

            @Override
            public DocIdSetIterator iterator() {
                return this.originalScorer.iterator();
            }
        }
    }
}

