/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.ErrorCode;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorFactory {
    public HashMap<String, double[]> wordLangProbMap = new HashMap();
    public ArrayList<String> langlist = new ArrayList();
    public Long seed = null;
    private static DetectorFactory instance_ = new DetectorFactory();

    private DetectorFactory() {
    }

    public static void loadProfile(String string) throws LangDetectException {
        DetectorFactory.loadProfile(new File(string));
    }

    public static void loadProfile(File file) throws LangDetectException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "Not found profile: " + file);
        }
        int n = fileArray.length;
        int n2 = 0;
        for (File file2 : fileArray) {
            if (file2.getName().startsWith(".") || !file2.isFile()) continue;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                LangProfile langProfile = (LangProfile)JSON.decode((InputStream)fileInputStream, LangProfile.class);
                DetectorFactory.addProfile(langProfile, n2, n);
                ++n2;
            }
            catch (JSONException jSONException) {
                throw new LangDetectException(ErrorCode.FormatError, "profile format error in '" + file2.getName() + "'");
            }
            catch (IOException iOException) {
                throw new LangDetectException(ErrorCode.FileLoadError, "can't open '" + file2.getName() + "'");
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void loadProfile(List<String> list) throws LangDetectException {
        int n = 0;
        int n2 = list.size();
        if (n2 < 2) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "Need more than 2 profiles");
        }
        for (String string : list) {
            try {
                LangProfile langProfile = (LangProfile)JSON.decode((String)string, LangProfile.class);
                DetectorFactory.addProfile(langProfile, n, n2);
                ++n;
            }
            catch (JSONException jSONException) {
                throw new LangDetectException(ErrorCode.FormatError, "profile format error");
            }
        }
    }

    static void addProfile(LangProfile langProfile, int n, int n2) throws LangDetectException {
        String string = langProfile.name;
        if (DetectorFactory.instance_.langlist.contains(string)) {
            throw new LangDetectException(ErrorCode.DuplicateLangError, "duplicate the same language profile");
        }
        DetectorFactory.instance_.langlist.add(string);
        for (String string2 : langProfile.freq.keySet()) {
            double d;
            int n3;
            if (!DetectorFactory.instance_.wordLangProbMap.containsKey(string2)) {
                DetectorFactory.instance_.wordLangProbMap.put(string2, new double[n2]);
            }
            if ((n3 = string2.length()) < 1 || n3 > 3) continue;
            DetectorFactory.instance_.wordLangProbMap.get((Object)string2)[n] = d = langProfile.freq.get(string2).doubleValue() / (double)langProfile.n_words[n3 - 1];
        }
    }

    public static void clear() {
        DetectorFactory.instance_.langlist.clear();
        DetectorFactory.instance_.wordLangProbMap.clear();
    }

    public static Detector create() throws LangDetectException {
        return DetectorFactory.createDetector();
    }

    public static Detector create(double d) throws LangDetectException {
        Detector detector = DetectorFactory.createDetector();
        detector.setAlpha(d);
        return detector;
    }

    private static Detector createDetector() throws LangDetectException {
        if (DetectorFactory.instance_.langlist.size() == 0) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "need to load profiles");
        }
        Detector detector = new Detector(instance_);
        return detector;
    }

    public static void setSeed(long l) {
        DetectorFactory.instance_.seed = l;
    }

    public static final List<String> getLangList() {
        return Collections.unmodifiableList(DetectorFactory.instance_.langlist);
    }
}

