/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;

public abstract class SingleDoubleFunction
extends ValueSource {
    protected final ValueSource source;

    public SingleDoubleFunction(ValueSource source) {
        this.source = source;
    }

    public String description() {
        return this.name() + "(" + this.source.description() + ")";
    }

    abstract String name();

    abstract double func(int var1, FunctionValues var2);

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vals = this.source.getValues(context, readerContext);
        return new DoubleDocValues(this){

            public double doubleVal(int doc) {
                return SingleDoubleFunction.this.func(doc, vals);
            }

            public boolean exists(int doc) {
                return vals.exists(doc);
            }

            public String toString(int doc) {
                return SingleDoubleFunction.this.name() + '(' + vals.toString(doc) + ')';
            }
        };
    }

    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SingleDoubleFunction other = (SingleDoubleFunction)((Object)o);
        return this.source.equals((Object)other.source);
    }

    public int hashCode() {
        return this.source.hashCode() + this.name().hashCode();
    }
}

