/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.request;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.analytics.request.ExpressionRequest;
import org.apache.solr.analytics.request.FieldFacetRequest;
import org.apache.solr.analytics.request.QueryFacetRequest;
import org.apache.solr.analytics.request.RangeFacetRequest;

public class AnalyticsRequest {
    private String name;
    private List<ExpressionRequest> expressions;
    private Set<String> hiddenExpressions;
    private List<FieldFacetRequest> fieldFacets;
    private List<RangeFacetRequest> rangeFacets;
    private List<QueryFacetRequest> queryFacets;

    public AnalyticsRequest(String name) {
        this.name = name;
        this.expressions = new ArrayList<ExpressionRequest>();
        this.hiddenExpressions = new HashSet<String>();
        this.fieldFacets = new ArrayList<FieldFacetRequest>();
        this.rangeFacets = new ArrayList<RangeFacetRequest>();
        this.queryFacets = new ArrayList<QueryFacetRequest>();
    }

    public String getName() {
        return this.name;
    }

    public void setExpressions(List<ExpressionRequest> expressions) {
        this.expressions = expressions;
    }

    public void addExpression(ExpressionRequest expressionRequest) {
        this.expressions.add(expressionRequest);
    }

    public List<ExpressionRequest> getExpressions() {
        return this.expressions;
    }

    public void addHiddenExpression(ExpressionRequest expressionRequest) {
        this.expressions.add(expressionRequest);
        this.hiddenExpressions.add(expressionRequest.getName());
    }

    public Set<String> getHiddenExpressions() {
        return this.hiddenExpressions;
    }

    public void setFieldFacets(List<FieldFacetRequest> fieldFacets) {
        this.fieldFacets = fieldFacets;
    }

    public List<FieldFacetRequest> getFieldFacets() {
        return this.fieldFacets;
    }

    public void setRangeFacets(List<RangeFacetRequest> rangeFacets) {
        this.rangeFacets = rangeFacets;
    }

    public List<RangeFacetRequest> getRangeFacets() {
        return this.rangeFacets;
    }

    public void setQueryFacets(List<QueryFacetRequest> queryFacets) {
        this.queryFacets = queryFacets;
    }

    public List<QueryFacetRequest> getQueryFacets() {
        return this.queryFacets;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<AnalyticsRequest name=" + this.name + ">");
        for (ExpressionRequest expressionRequest : this.expressions) {
            builder.append(expressionRequest.toString());
        }
        for (FieldFacetRequest fieldFacetRequest : this.fieldFacets) {
            builder.append(fieldFacetRequest.toString());
        }
        for (RangeFacetRequest rangeFacetRequest : this.rangeFacets) {
            builder.append(rangeFacetRequest.toString());
        }
        for (QueryFacetRequest queryFacetRequest : this.queryFacets) {
            builder.append(queryFacetRequest.toString());
        }
        builder.append("</AnalyticsRequest>");
        return builder.toString();
    }
}

