/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.plugin;

import com.codahale.metrics.Timer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.util.stats.MetricUtils;

public class AnalyticsStatisticsCollector {
    private final AtomicLong numRequests = new AtomicLong();
    private final AtomicLong numAnalyticsRequests = new AtomicLong();
    private final AtomicLong numStatsRequests = new AtomicLong();
    private final AtomicLong numCollectedStats = new AtomicLong();
    private final AtomicLong numFieldFacets = new AtomicLong();
    private final AtomicLong numRangeFacets = new AtomicLong();
    private final AtomicLong numQueryFacets = new AtomicLong();
    private final AtomicLong numQueries = new AtomicLong();
    private final Timer requestTimes = new Timer();
    public Timer.Context currentTimer;

    public void startRequest() {
        this.numRequests.incrementAndGet();
        this.currentTimer = this.requestTimes.time();
    }

    public void addRequests(long num) {
        this.numAnalyticsRequests.addAndGet(num);
    }

    public void addStatsRequests(long num) {
        this.numStatsRequests.addAndGet(num);
    }

    public void addStatsCollected(long num) {
        this.numCollectedStats.addAndGet(num);
    }

    public void addFieldFacets(long num) {
        this.numFieldFacets.addAndGet(num);
    }

    public void addRangeFacets(long num) {
        this.numRangeFacets.addAndGet(num);
    }

    public void addQueryFacets(long num) {
        this.numQueryFacets.addAndGet(num);
    }

    public void addQueries(long num) {
        this.numQueries.addAndGet(num);
    }

    public void endRequest() {
        this.currentTimer.stop();
    }

    public NamedList<Object> getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("requests", (Object)this.numRequests.longValue());
        lst.add("analyticsRequests", (Object)this.numAnalyticsRequests.longValue());
        lst.add("statsRequests", (Object)this.numStatsRequests.longValue());
        lst.add("statsCollected", (Object)this.numCollectedStats.longValue());
        lst.add("fieldFacets", (Object)this.numFieldFacets.longValue());
        lst.add("rangeFacets", (Object)this.numRangeFacets.longValue());
        lst.add("queryFacets", (Object)this.numQueryFacets.longValue());
        lst.add("queriesInQueryFacets", (Object)this.numQueries.longValue());
        MetricUtils.addMetrics((NamedList)lst, (Timer)this.requestTimes);
        return lst;
    }
}

