/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LegacyNumericUtils;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;

public class AnalyticsParsers {
    public static final NumericParser INT_DOC_VALUES_PARSER = new NumericParser(){

        @Override
        public String parse(BytesRef bytes) throws IOException {
            try {
                return "" + LegacyNumericUtils.prefixCodedToInt((BytesRef)bytes);
            }
            catch (NumberFormatException e) {
                throw new IOException("The byte array " + Arrays.toString(bytes.bytes) + " cannot be converted to an int.");
            }
        }

        @Override
        public String parseNum(long l) {
            return "" + (int)l;
        }
    };
    public static final NumericParser LONG_DOC_VALUES_PARSER = new NumericParser(){

        @Override
        public String parse(BytesRef bytes) throws IOException {
            try {
                return "" + LegacyNumericUtils.prefixCodedToLong((BytesRef)bytes);
            }
            catch (NumberFormatException e) {
                throw new IOException("The byte array " + Arrays.toString(bytes.bytes) + " cannot be converted to a long.");
            }
        }

        @Override
        public String parseNum(long l) {
            return "" + l;
        }
    };
    public static final NumericParser FLOAT_DOC_VALUES_PARSER = new NumericParser(){

        @Override
        public String parse(BytesRef bytes) throws IOException {
            try {
                return "" + NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt((BytesRef)bytes));
            }
            catch (NumberFormatException e) {
                throw new IOException("The byte array " + Arrays.toString(bytes.bytes) + " cannot be converted to a float.");
            }
        }

        @Override
        public String parseNum(long l) {
            return "" + NumericUtils.sortableIntToFloat((int)((int)l));
        }
    };
    public static final NumericParser DOUBLE_DOC_VALUES_PARSER = new NumericParser(){

        @Override
        public String parse(BytesRef bytes) throws IOException {
            try {
                return "" + NumericUtils.sortableLongToDouble((long)LegacyNumericUtils.prefixCodedToLong((BytesRef)bytes));
            }
            catch (NumberFormatException e) {
                throw new IOException("The byte array " + Arrays.toString(bytes.bytes) + " cannot be converted to a double.");
            }
        }

        @Override
        public String parseNum(long l) {
            return "" + NumericUtils.sortableLongToDouble((long)l);
        }
    };
    public static final NumericParser DATE_DOC_VALUES_PARSER = new NumericParser(){

        @Override
        public String parse(BytesRef bytes) throws IOException {
            try {
                return Instant.ofEpochMilli(LegacyNumericUtils.prefixCodedToLong((BytesRef)bytes)).toString();
            }
            catch (NumberFormatException e) {
                throw new IOException("The byte array " + Arrays.toString(bytes.bytes) + " cannot be converted to a date.");
            }
        }

        @Override
        public String parseNum(long l) {
            return Instant.ofEpochMilli(l).toString();
        }
    };
    public static final Parser STRING_PARSER = new Parser(){

        @Override
        public String parse(BytesRef bytes) {
            return bytes.utf8ToString();
        }
    };

    public static Parser getParser(Class<? extends FieldType> class1) {
        if (class1.equals(TrieIntField.class)) {
            return INT_DOC_VALUES_PARSER;
        }
        if (class1.equals(TrieLongField.class)) {
            return LONG_DOC_VALUES_PARSER;
        }
        if (class1.equals(TrieFloatField.class)) {
            return FLOAT_DOC_VALUES_PARSER;
        }
        if (class1.equals(TrieDoubleField.class)) {
            return DOUBLE_DOC_VALUES_PARSER;
        }
        if (class1.equals(TrieDateField.class)) {
            return DATE_DOC_VALUES_PARSER;
        }
        return STRING_PARSER;
    }

    public static interface NumericParser
    extends Parser {
        public String parseNum(long var1);
    }

    public static interface Parser {
        public String parse(BytesRef var1) throws IOException;
    }
}

