/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.accumulator;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.analytics.accumulator.ValueAccumulator;
import org.apache.solr.analytics.expression.Expression;
import org.apache.solr.analytics.expression.ExpressionFactory;
import org.apache.solr.analytics.request.AnalyticsRequest;
import org.apache.solr.analytics.request.ExpressionRequest;
import org.apache.solr.analytics.statistics.StatsCollector;
import org.apache.solr.analytics.statistics.StatsCollectorSupplierFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.DateFormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAccumulator
extends ValueAccumulator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrIndexSearcher searcher;
    protected final AnalyticsRequest request;
    protected final DocSet docs;
    protected final Supplier<StatsCollector[]> statsCollectorArraySupplier;
    protected final StatsCollector[] statsCollectors;
    protected final Expression[] expressions;
    protected final String[] expressionNames;
    protected final String[] expressionStrings;
    protected final Set<String> hiddenExpressions;
    protected LeafReaderContext context = null;

    public BasicAccumulator(SolrIndexSearcher searcher, DocSet docs, AnalyticsRequest request) throws IOException {
        this.searcher = searcher;
        this.docs = docs;
        this.request = request;
        ArrayList<ExpressionRequest> exRequests = new ArrayList<ExpressionRequest>(request.getExpressions());
        Collections.sort(exRequests);
        log.info("Processing request '" + request.getName() + "'");
        this.statsCollectorArraySupplier = StatsCollectorSupplierFactory.create(searcher.getSchema(), exRequests);
        this.statsCollectors = (StatsCollector[])this.statsCollectorArraySupplier.get();
        int size = exRequests.size();
        this.expressionNames = new String[size];
        this.expressionStrings = new String[size];
        int count = 0;
        for (ExpressionRequest expRequest : exRequests) {
            this.expressionNames[count] = expRequest.getName();
            this.expressionStrings[count++] = expRequest.getExpressionString();
        }
        this.expressions = this.makeExpressions(this.statsCollectors);
        this.hiddenExpressions = request.getHiddenExpressions();
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.context = context;
        for (StatsCollector counter : this.statsCollectors) {
            counter.setNextReader(context);
        }
    }

    public static BasicAccumulator create(SolrIndexSearcher searcher, DocSet docs, AnalyticsRequest request) throws IOException {
        return new BasicAccumulator(searcher, docs, request);
    }

    public void collect(int doc) throws IOException {
        for (StatsCollector statsCollector : this.statsCollectors) {
            statsCollector.collect(doc);
        }
    }

    @Override
    public void compute() {
        for (StatsCollector statsCollector : this.statsCollectors) {
            statsCollector.compute();
        }
    }

    @Override
    public NamedList<?> export() {
        NamedList base = new NamedList();
        for (int count = 0; count < this.expressions.length; ++count) {
            if (this.hiddenExpressions.contains(this.expressionNames[count])) continue;
            base.add(this.expressionNames[count], (Object)this.expressions[count].getValue());
        }
        return base;
    }

    public Expression[] makeExpressions(StatsCollector[] statsCollectors) {
        Expression[] expressions = new Expression[this.expressionStrings.length];
        for (int count = 0; count < this.expressionStrings.length; ++count) {
            expressions[count] = ExpressionFactory.create(this.expressionStrings[count], statsCollectors);
        }
        return expressions;
    }

    public String getResult(String expressionName) {
        for (int count = 0; count < this.expressionNames.length; ++count) {
            if (!expressionName.equals(this.expressionNames[count])) continue;
            Comparable value = this.expressions[count].getValue();
            if (value.getClass().equals(Date.class)) {
                return DateFormatUtil.formatExternal((Date)((Date)value));
            }
            return value.toString();
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Pivot expression " + expressionName + " not found.");
    }

    public long getNumStatsCollectors() {
        return this.statsCollectors.length;
    }

    public long getNumQueries() {
        return 0L;
    }

    public boolean needsScores() {
        return true;
    }
}

