/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.analytics.request.AnalyticsRequest;
import org.apache.solr.analytics.request.ExpressionRequest;
import org.apache.solr.analytics.request.FieldFacetRequest;
import org.apache.solr.analytics.request.QueryFacetRequest;
import org.apache.solr.analytics.request.RangeFacetRequest;
import org.apache.solr.analytics.util.AnalyticsParams;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.schema.IndexSchema;

public class AnalyticsRequestFactory
implements AnalyticsParams {
    public static final Pattern statPattern = Pattern.compile("^o(?:lap)?\\.([^\\.]+)\\.(?:s|stat|statistic)\\.([^\\.]+)$", 2);
    public static final Pattern hiddenStatPattern = Pattern.compile("^o(?:lap)?\\.([^\\.]+)\\.(?:hs|hiddenstat|hiddenstatistic)\\.([^\\.]+)$", 2);
    public static final Pattern fieldFacetPattern = Pattern.compile("^o(?:lap)?\\.([^\\.]+)\\.(?:ff|fieldfacet)$", 2);
    public static final Pattern fieldFacetParamPattern = Pattern.compile("^o(?:lap)?\\.([^\\.]+)\\.(?:ff|fieldfacet)\\.([^\\.]+)\\.(l|limit|off|offset|h|hidden|sm|showmissing|ss|sortstat|sortstatistic|sd|sortdirection)$", 2);
    public static final Pattern rangeFacetPattern = Pattern.compile("^o(?:lap)?\\.([^\\.]+)\\.(?:rf|rangefacet)$", 2);
    public static final Pattern rangeFacetParamPattern = Pattern.compile("^o(?:lap)?\\.([^\\.]+)\\.(?:rf|rangefacet)\\.([^\\.]+)\\.(st|start|e|end|g|gap|he|hardend|ib|includebound|or|otherrange)$", 2);
    public static final Pattern queryFacetPattern = Pattern.compile("^o(?:lap)?\\.([^\\.]+)\\.(?:qf|queryfacet)$", 2);
    public static final Pattern queryFacetParamPattern = Pattern.compile("^o(?:lap)?\\.([^\\.]+)\\.(?:qf|queryfacet)\\.([^\\.]+)\\.(q|query|d|dependecy)$", 2);

    public static List<AnalyticsRequest> parse(IndexSchema schema, SolrParams params) {
        HashMap<String, AnalyticsRequest> requestMap = new HashMap<String, AnalyticsRequest>();
        HashMap<String, Map<String, FieldFacetRequest>> fieldFacetMap = new HashMap<String, Map<String, FieldFacetRequest>>();
        HashMap<String, Set<String>> fieldFacetSet = new HashMap<String, Set<String>>();
        HashMap<String, Map<String, RangeFacetRequest>> rangeFacetMap = new HashMap<String, Map<String, RangeFacetRequest>>();
        HashMap<String, Set<String>> rangeFacetSet = new HashMap<String, Set<String>>();
        HashMap<String, Map<String, QueryFacetRequest>> queryFacetMap = new HashMap<String, Map<String, QueryFacetRequest>>();
        HashMap<String, Set<String>> queryFacetSet = new HashMap<String, Set<String>>();
        ArrayList<AnalyticsRequest> requestList = new ArrayList<AnalyticsRequest>();
        Iterator paramsIterator = params.getParameterNamesIterator();
        while (paramsIterator.hasNext()) {
            String param = (String)paramsIterator.next();
            CharSequence paramSequence = param.subSequence(0, param.length());
            Matcher m = statPattern.matcher(paramSequence);
            if (m.matches()) {
                AnalyticsRequestFactory.makeExpression(requestMap, m.group(1), m.group(2), params.get(param));
                continue;
            }
            m = hiddenStatPattern.matcher(paramSequence);
            if (m.matches()) {
                AnalyticsRequestFactory.makeHiddenExpression(requestMap, m.group(1), m.group(2), params.get(param));
                continue;
            }
            m = fieldFacetPattern.matcher(paramSequence);
            if (m.matches()) {
                AnalyticsRequestFactory.makeFieldFacet(schema, fieldFacetMap, fieldFacetSet, m.group(1), params.getParams(param));
                continue;
            }
            m = fieldFacetParamPattern.matcher(paramSequence);
            if (m.matches()) {
                AnalyticsRequestFactory.setFieldFacetParam(schema, fieldFacetMap, m.group(1), m.group(2), m.group(3), params.getParams(param));
                continue;
            }
            m = rangeFacetPattern.matcher(paramSequence);
            if (m.matches()) {
                AnalyticsRequestFactory.makeRangeFacet(schema, rangeFacetSet, m.group(1), params.getParams(param));
                continue;
            }
            m = rangeFacetParamPattern.matcher(paramSequence);
            if (m.matches()) {
                AnalyticsRequestFactory.setRangeFacetParam(schema, rangeFacetMap, m.group(1), m.group(2), m.group(3), params.getParams(param));
                continue;
            }
            m = queryFacetPattern.matcher(paramSequence);
            if (m.matches()) {
                AnalyticsRequestFactory.makeQueryFacet(schema, queryFacetSet, m.group(1), params.getParams(param));
                continue;
            }
            m = queryFacetParamPattern.matcher(paramSequence);
            if (!m.matches()) continue;
            AnalyticsRequestFactory.setQueryFacetParam(schema, queryFacetMap, m.group(1), m.group(2), m.group(3), params.getParams(param));
        }
        for (String reqName : requestMap.keySet()) {
            AnalyticsRequest ar = (AnalyticsRequest)requestMap.get(reqName);
            ArrayList<FieldFacetRequest> ffrs = new ArrayList<FieldFacetRequest>();
            if (fieldFacetSet.get(reqName) != null) {
                for (String field : (Set)fieldFacetSet.get(reqName)) {
                    ffrs.add((FieldFacetRequest)((Map)fieldFacetMap.get(reqName)).get(field));
                }
            }
            ar.setFieldFacets(ffrs);
            ArrayList<RangeFacetRequest> rfrs = new ArrayList<RangeFacetRequest>();
            if (rangeFacetSet.get(reqName) != null) {
                for (String field : (Set)rangeFacetSet.get(reqName)) {
                    RangeFacetRequest rfr = (RangeFacetRequest)((Map)rangeFacetMap.get(reqName)).get(field);
                    if (rfr == null) continue;
                    rfrs.add(rfr);
                }
            }
            ar.setRangeFacets(rfrs);
            ArrayList<QueryFacetRequest> qfrs = new ArrayList<QueryFacetRequest>();
            if (queryFacetSet.get(reqName) != null) {
                for (String name : (Set)queryFacetSet.get(reqName)) {
                    QueryFacetRequest qfr = (QueryFacetRequest)((Map)queryFacetMap.get(reqName)).get(name);
                    if (qfr == null) continue;
                    AnalyticsRequestFactory.addQueryFacet(qfrs, qfr);
                }
            }
            for (QueryFacetRequest qfr : qfrs) {
                if (qfr.getDependencies().size() <= 0) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The query facet dependencies " + qfr.getDependencies().toString() + " either do not exist or are defined in a dependency looop.");
            }
            ar.setQueryFacets(qfrs);
            requestList.add(ar);
        }
        return requestList;
    }

    private static void makeFieldFacet(IndexSchema schema, Map<String, Map<String, FieldFacetRequest>> fieldFacetMap, Map<String, Set<String>> fieldFacetSet, String requestName, String[] fields) {
        Set<String> set;
        Map<String, FieldFacetRequest> facetMap = fieldFacetMap.get(requestName);
        if (facetMap == null) {
            facetMap = new HashMap<String, FieldFacetRequest>();
            fieldFacetMap.put(requestName, facetMap);
        }
        if ((set = fieldFacetSet.get(requestName)) == null) {
            set = new HashSet<String>();
            fieldFacetSet.put(requestName, set);
        }
        for (String field : fields) {
            if (facetMap.get(field) == null) {
                facetMap.put(field, new FieldFacetRequest(schema.getField(field)));
            }
            set.add(field);
        }
    }

    private static void setFieldFacetParam(IndexSchema schema, Map<String, Map<String, FieldFacetRequest>> fieldFacetMap, String requestName, String field, String paramType, String[] params) {
        FieldFacetRequest fr;
        Map<String, FieldFacetRequest> facetMap = fieldFacetMap.get(requestName);
        if (facetMap == null) {
            facetMap = new HashMap<String, FieldFacetRequest>();
            fieldFacetMap.put(requestName, facetMap);
        }
        if ((fr = facetMap.get(field)) == null) {
            fr = new FieldFacetRequest(schema.getField(field));
            facetMap.put(field, fr);
        }
        if (paramType.equals("limit") || paramType.equals("l")) {
            fr.setLimit(Integer.parseInt(params[0]));
        } else if (paramType.equals("offset") || paramType.equals("off")) {
            fr.setOffset(Integer.parseInt(params[0]));
        } else if (paramType.equals("hidden") || paramType.equals("h")) {
            fr.setHidden(Boolean.parseBoolean(params[0]));
        } else if (paramType.equals("showmissing") || paramType.equals("sm")) {
            fr.showMissing(Boolean.parseBoolean(params[0]));
        } else if (paramType.equals("sortstatistic") || paramType.equals("sortstat") || paramType.equals("ss")) {
            fr.setSort(new FieldFacetRequest.FacetSortSpecification(params[0], fr.getDirection()));
        } else if (paramType.equals("sortdirection") || paramType.equals("sd")) {
            fr.setDirection(params[0]);
        }
    }

    private static void makeRangeFacet(IndexSchema schema, Map<String, Set<String>> rangeFacetSet, String requestName, String[] fields) {
        Set<String> set = rangeFacetSet.get(requestName);
        if (set == null) {
            set = new HashSet<String>();
            rangeFacetSet.put(requestName, set);
        }
        for (String field : fields) {
            set.add(field);
        }
    }

    private static void setRangeFacetParam(IndexSchema schema, Map<String, Map<String, RangeFacetRequest>> rangeFacetMap, String requestName, String field, String paramType, String[] params) {
        block5: {
            RangeFacetRequest rr;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                Map<String, RangeFacetRequest> facetMap = rangeFacetMap.get(requestName);
                                if (facetMap == null) {
                                    facetMap = new HashMap<String, RangeFacetRequest>();
                                    rangeFacetMap.put(requestName, facetMap);
                                }
                                if ((rr = facetMap.get(field)) == null) {
                                    rr = new RangeFacetRequest(schema.getField(field));
                                    facetMap.put(field, rr);
                                }
                                if (!paramType.equals("start") && !paramType.equals("st")) break block4;
                                rr.setStart(params[0]);
                                break block5;
                            }
                            if (!paramType.equals("end") && !paramType.equals("e")) break block6;
                            rr.setEnd(params[0]);
                            break block5;
                        }
                        if (!paramType.equals("gap") && !paramType.equals("g")) break block7;
                        rr.setGaps(params[0].split(","));
                        break block5;
                    }
                    if (!paramType.equals("hardend") && !paramType.equals("he")) break block8;
                    rr.setHardEnd(Boolean.parseBoolean(params[0]));
                    break block5;
                }
                if (!paramType.equals("includebound") && !paramType.equals("ib")) break block9;
                for (String param : params) {
                    rr.addInclude(FacetParams.FacetRangeInclude.get((String)param));
                }
                break block5;
            }
            if (!paramType.equals("otherrange") && !paramType.equals("or")) break block5;
            for (String param : params) {
                rr.addOther(FacetParams.FacetRangeOther.get((String)param));
            }
        }
    }

    private static void makeQueryFacet(IndexSchema schema, Map<String, Set<String>> queryFacetSet, String requestName, String[] names) {
        Set<String> set = queryFacetSet.get(requestName);
        if (set == null) {
            set = new HashSet<String>();
            queryFacetSet.put(requestName, set);
        }
        for (String name : names) {
            set.add(name);
        }
    }

    private static void setQueryFacetParam(IndexSchema schema, Map<String, Map<String, QueryFacetRequest>> queryFacetMap, String requestName, String name, String paramType, String[] params) {
        block5: {
            QueryFacetRequest qr;
            block4: {
                Map<String, QueryFacetRequest> facetMap = queryFacetMap.get(requestName);
                if (facetMap == null) {
                    facetMap = new HashMap<String, QueryFacetRequest>();
                    queryFacetMap.put(requestName, facetMap);
                }
                if ((qr = facetMap.get(name)) == null) {
                    qr = new QueryFacetRequest(name);
                    facetMap.put(name, qr);
                }
                if (!paramType.equals("query") && !paramType.equals("q")) break block4;
                for (String query : params) {
                    qr.addQuery(query);
                }
                break block5;
            }
            if (!paramType.equals("dependency") && !paramType.equals("d")) break block5;
            for (String depend : params) {
                qr.addDependency(depend);
            }
        }
    }

    private static void makeHiddenExpression(Map<String, AnalyticsRequest> requestMap, String requestName, String expressionName, String expression) {
        AnalyticsRequest req = requestMap.get(requestName);
        if (req == null) {
            req = new AnalyticsRequest(requestName);
            requestMap.put(requestName, req);
        }
        req.addHiddenExpression(new ExpressionRequest(expressionName, expression));
    }

    private static void makeExpression(Map<String, AnalyticsRequest> requestMap, String requestName, String expressionName, String expression) {
        AnalyticsRequest req = requestMap.get(requestName);
        if (req == null) {
            req = new AnalyticsRequest(requestName);
            requestMap.put(requestName, req);
        }
        req.addExpression(new ExpressionRequest(expressionName, expression));
    }

    private static void addQueryFacet(List<QueryFacetRequest> currentList, QueryFacetRequest queryFacet) {
        Set<String> depends = queryFacet.getDependencies();
        int place = 0;
        for (QueryFacetRequest qfr : currentList) {
            if (qfr.getDependencies().remove(queryFacet.getName())) break;
            ++place;
            depends.remove(qfr.getName());
        }
        currentList.add(place, queryFacet);
        for (int count = place + 1; count < currentList.size(); ++count) {
            currentList.get(count).getDependencies().remove(queryFacet.getName());
        }
    }
}

