/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.fsclassloader.impl;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.commons.classloader.DynamicClassLoader;

public class FSDynamicClassLoader
extends URLClassLoader
implements DynamicClassLoader {
    private boolean isDirty = false;
    private final Set<String> hit = Collections.synchronizedSet(new HashSet());
    private final Set<String> miss = Collections.synchronizedSet(new HashSet());
    private final DynamicClassLoader parentLoader;

    public FSDynamicClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parentLoader = parent instanceof DynamicClassLoader ? (DynamicClassLoader)parent : null;
    }

    public boolean isLive() {
        return !this.isDirty && (this.parentLoader == null || this.parentLoader.isLive());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            Class<?> c = super.loadClass(name);
            this.hit.add(name);
            return c;
        }
        catch (ClassNotFoundException cnfe) {
            this.miss.add(name);
            throw cnfe;
        }
    }

    public void check(String className) {
        if (!this.isDirty) {
            this.isDirty = this.hit.contains(className) || this.miss.contains(className);
        }
    }
}

