/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.fsclassloader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Web Console for the FileSystem Class Loader"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="felix.webconsole.label", value={"fsclassloader"}), @Property(name="felix.webconsole.title", value={"File System Class Loader"}), @Property(name="felix.webconsole.css", value={"fsclassloader/res/ui/prettify.css"}), @Property(name="felix.webconsole.category", value={"Sling"})})
public class FSClassLoaderWebConsole
extends AbstractWebConsolePlugin {
    static final String APP_ROOT = "fsclassloader";
    static final String RES_LOC = "fsclassloader/res/ui";
    static final String POST_PARAM_CLEAR_CLASSLOADER = "clear";
    private static final Logger LOG = LoggerFactory.getLogger(FSClassLoaderWebConsole.class);
    @Reference(target="(component.name=org.apache.sling.commons.fsclassloader.impl.FSClassLoaderProvider)")
    private ClassLoaderWriter classLoaderWriter;
    private static File root;
    private static final long serialVersionUID = -5728679635644481848L;
    private ServletConfig config;

    @Activate
    protected void activate(ComponentContext componentContext) throws MalformedURLException {
        root = new File(componentContext.getBundleContext().getDataFile(""), "classes");
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block10: {
            block8: {
                String file;
                block9: {
                    file = request.getParameter("download");
                    File toDownload = new File(root + file);
                    if (StringUtils.isEmpty((CharSequence)file)) break block8;
                    if (!this.isValid(toDownload)) break block9;
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(toDownload);
                        response.setHeader("Content-disposition", "attachment; filename=" + toDownload.getName());
                        IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        IOUtils.closeQuietly((OutputStream)response.getOutputStream());
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly((OutputStream)response.getOutputStream());
                    break block10;
                }
                response.sendError(404, "File " + file + " not found");
                break block10;
            }
            if (request.getRequestURI().endsWith("fsclassloader/res/ui/prettify.css")) {
                response.setContentType("text/css");
                IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/res/ui/prettify.css"), (OutputStream)response.getOutputStream());
            } else if (request.getRequestURI().endsWith("fsclassloader/res/ui/prettify.js")) {
                response.setContentType("application/javascript");
                IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/res/ui/prettify.js"), (OutputStream)response.getOutputStream());
            } else if (request.getRequestURI().endsWith("fsclassloader/res/ui/fsclassloader.js")) {
                response.setContentType("application/javascript");
                IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/res/ui/fsclassloader.js"), (OutputStream)response.getOutputStream());
            } else {
                super.doGet(request, response);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String clear = req.getParameter(POST_PARAM_CLEAR_CLASSLOADER);
        boolean shouldClear = Boolean.parseBoolean(clear);
        if (shouldClear) {
            if (this.classLoaderWriter != null) {
                boolean result = this.classLoaderWriter.delete("");
                if (result) {
                    resp.getWriter().write("{ \"status\" : \"success\" }");
                    resp.setStatus(200);
                } else {
                    resp.getWriter().write("{ \"status\" : \"failure\", \"message\" : \"unable to clear classloader; check server log\" }");
                    resp.setStatus(500);
                }
            } else {
                LOG.error("Cannot get a reference to org.apache.sling.commons.fsclassloader.impl.FSClassLoaderProvider");
                resp.getWriter().write("{ \"status\" : \"failure\", \"message\" : \"unable to clear classloader; check server log\" }");
                resp.setStatus(500);
            }
        } else {
            resp.getWriter().write("{ \"status\" : \"failure\", \"message\" : \"invalid command\" }");
            resp.setStatus(400);
        }
    }

    public String getLabel() {
        return APP_ROOT;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "";
    }

    public String getTitle() {
        return "File System Class Loader";
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
    }

    private boolean isValid(File file) throws IOException {
        if (file.isFile()) {
            for (File parent = file.getCanonicalFile().getAbsoluteFile().getParentFile(); parent != null; parent = parent.getParentFile()) {
                if (!parent.getCanonicalPath().equals(root.getCanonicalPath())) continue;
                return true;
            }
        }
        return false;
    }

    private void readFiles(File file, Map<String, ScriptFiles> scripts) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File f : children) {
                    this.readFiles(f, scripts);
                }
            }
        } else {
            String script = ScriptFiles.getScript(file);
            if (!scripts.containsKey(script) && file.getName().endsWith(".java")) {
                scripts.put(script, new ScriptFiles(file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter w;
        block7: {
            LinkedHashMap<String, ScriptFiles> scripts;
            block5: {
                String file;
                block6: {
                    scripts = new LinkedHashMap<String, ScriptFiles>();
                    this.readFiles(root, scripts);
                    w = response.getWriter();
                    ((Writer)w).write("<link rel=\"stylesheet\" type=\"text/css\" href=\"fsclassloader/res/ui/prettify.css\"></link>");
                    ((Writer)w).write("<script type=\"text/javascript\" src=\"fsclassloader/res/ui/prettify.js\"></script>");
                    ((Writer)w).write("<script type=\"text/javascript\" src=\"fsclassloader/res/ui/fsclassloader.js\"></script>");
                    ((Writer)w).write("<script>$(document).ready(prettyPrint);</script>");
                    ((Writer)w).write("<style>.prettyprint ol.linenums > li { list-style-type: decimal; } pre.prettyprint { white-space: pre-wrap; }</style>");
                    file = request.getParameter("view");
                    File toView = new File(root + file);
                    ((Writer)w).write("<div id=\"classes\">");
                    if (StringUtils.isEmpty((CharSequence)file)) break block5;
                    if (!this.isValid(toView)) break block6;
                    ((Writer)w).write("<p class=\"statline ui-state-highlight\">Viewing Script: " + root + file + "</p><br/><br/>");
                    ScriptFiles scriptFiles = new ScriptFiles(toView);
                    ((Writer)w).write("<table class=\"nicetable ui-widget\">");
                    ((Writer)w).write("<tr class=\"header ui-widget-header\">");
                    ((Writer)w).write("<th>Script</th>");
                    ((Writer)w).write("<th>Class</th>");
                    ((Writer)w).write("<th>Deps</th>");
                    ((Writer)w).write("<th>Java</th>");
                    ((Writer)w).write("</tr>");
                    ((Writer)w).write("<tr class=\"ui-state-default\">");
                    ((Writer)w).write("<td>" + scriptFiles.getScript() + "</td>");
                    ((Writer)w).write("<td>[<a href=\"?download=" + scriptFiles.getClassFile() + "\" target=\"_blank\">download</a>]</td>");
                    ((Writer)w).write("<td>[<a href=\"?download=" + scriptFiles.getDepsFile() + "\" target=\"_blank\">download</a>]</td>");
                    ((Writer)w).write("<td>[<a href=\"?download=" + scriptFiles.getJavaFile() + "\" target=\"_blank\">download</a>]</td>");
                    ((Writer)w).write("</tr>");
                    ((Writer)w).write("</table><br/><br/>");
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(toView);
                        String contents = IOUtils.toString((InputStream)is, (String)"UTF-8");
                        ((Writer)w).write("<pre class=\"prettyprint linenums\">");
                        ((Writer)w).write(StringEscapeUtils.escapeHtml4((String)contents));
                        ((Writer)w).write("</pre>");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    break block7;
                }
                response.sendError(404, "File " + file + " not found");
                break block7;
            }
            ((Writer)w).write("<p class=\"statline ui-state-highlight\">File System ClassLoader Root: " + root + " <span style=\"float: right\"><button type='button' id='clear'>Clear Class Loader</button></span></p>");
            if (scripts.values().size() > 0) {
                ((Writer)w).write("<table class=\"nicetable ui-widget fsclassloader-has-classes\">");
            } else {
                ((Writer)w).write("<table class=\"nicetable ui-widget\">");
            }
            ((Writer)w).write("<tr class=\"header ui-widget-header\">");
            ((Writer)w).write("<th>View</th>");
            ((Writer)w).write("<th>Script</th>");
            ((Writer)w).write("</tr>");
            int i = 0;
            for (ScriptFiles scriptFiles : scripts.values()) {
                ((Writer)w).write("<tr class=\"" + (i % 2 == 0 ? "even" : "odd") + " ui-state-default\">");
                ((Writer)w).write("<td>[<a href=\"?view=" + scriptFiles.getJavaFile() + "\">view</a>]</td>");
                ((Writer)w).write("<td>" + scriptFiles.getScript() + "</td>");
                ((Writer)w).write("</tr>");
                ++i;
            }
            ((Writer)w).write("</table>");
        }
        ((Writer)w).write("</div>");
    }

    protected void bindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        this.classLoaderWriter = classLoaderWriter;
    }

    protected void unbindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        if (this.classLoaderWriter == classLoaderWriter) {
            this.classLoaderWriter = null;
        }
    }

    private static class ScriptFiles {
        private final String classFile;
        private final String depsFile;
        private final String javaFile;
        private final String script;

        public static String getScript(File file) {
            String relative = file.getAbsolutePath().substring(root.getAbsolutePath().length());
            String script = ScriptFiles.remove(relative, "/org/apache/jsp");
            script = ScriptFiles.remove(script, ".class");
            script = ScriptFiles.remove(script, ".java");
            script = ScriptFiles.remove(script, ".deps");
            if (File.separatorChar == '\\') {
                script = script.replace(File.separatorChar, '/');
            }
            return StringUtils.substringBeforeLast((String)script, (String)"_") + "." + StringUtils.substringAfterLast((String)script, (String)"_");
        }

        private static String remove(String orig, String rem) {
            return orig.replace(rem, "");
        }

        public ScriptFiles(File file) {
            this.script = ScriptFiles.getScript(file);
            String relative = file.getAbsolutePath().substring(root.getAbsolutePath().length());
            relative = ScriptFiles.remove(relative, ".class");
            relative = ScriptFiles.remove(relative, ".deps");
            relative = ScriptFiles.remove(relative, ".java");
            this.classFile = relative + ".class";
            this.depsFile = relative + ".deps";
            this.javaFile = relative + ".java";
        }

        public String getClassFile() {
            return this.classFile;
        }

        public String getDepsFile() {
            return this.depsFile;
        }

        public String getJavaFile() {
            return this.javaFile;
        }

        public String getScript() {
            return this.script;
        }
    }
}

