/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.fsclassloader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.classloader.ClassLoaderWriterListener;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.fsclassloader.FSClassLoaderMBean;
import org.apache.sling.commons.fsclassloader.impl.FSClassLoaderMBeanImpl;
import org.apache.sling.commons.fsclassloader.impl.FSDynamicClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ClassLoaderWriter.class}, scope=ServiceScope.BUNDLE, property={"service.ranking:Integer=100"})
public class FSClassLoaderProvider
implements ClassLoaderWriter {
    private static final String LISTENER_FILTER = "(objectClass=" + ClassLoaderWriterListener.class.getName() + ")";
    private File root;
    private URL rootURL;
    private FSDynamicClassLoader loader;
    private static ServiceListener classLoaderWriterServiceListener;
    private Map<Long, ServiceReference<ClassLoaderWriterListener>> classLoaderWriterListeners = new HashMap<Long, ServiceReference<ClassLoaderWriterListener>>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference(service=DynamicClassLoaderManager.class)
    private ServiceReference<DynamicClassLoaderManager> dynamicClassLoaderManager;
    private Bundle callerBundle;
    private static ServiceRegistration<?> mbeanRegistration;

    @Activate
    protected void activate(ComponentContext componentContext) throws MalformedURLException, InvalidSyntaxException, MalformedObjectNameException {
        this.root = new File(componentContext.getBundleContext().getDataFile(""), "classes");
        this.root.mkdirs();
        this.rootURL = this.root.toURI().toURL();
        this.callerBundle = componentContext.getUsingBundle();
        this.classLoaderWriterListeners.clear();
        if (classLoaderWriterServiceListener != null) {
            componentContext.getBundleContext().removeServiceListener(classLoaderWriterServiceListener);
            classLoaderWriterServiceListener = null;
        }
        classLoaderWriterServiceListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                ServiceReference reference = event.getServiceReference();
                if (event.getType() == 2 || event.getType() == 1) {
                    FSClassLoaderProvider.this.classLoaderWriterListeners.put(this.getId((ServiceReference<ClassLoaderWriterListener>)reference), reference);
                } else {
                    FSClassLoaderProvider.this.classLoaderWriterListeners.remove(this.getId((ServiceReference<ClassLoaderWriterListener>)reference));
                }
            }

            private Long getId(ServiceReference<ClassLoaderWriterListener> reference) {
                return (Long)reference.getProperty("service.id");
            }
        };
        componentContext.getBundleContext().addServiceListener(classLoaderWriterServiceListener, LISTENER_FILTER);
        if (mbeanRegistration != null) {
            mbeanRegistration.unregister();
            mbeanRegistration = null;
        }
        Hashtable<String, String> jmxProps = new Hashtable<String, String>();
        jmxProps.put("type", "ClassLoader");
        jmxProps.put("name", "FSClassLoader");
        Hashtable<String, Object> mbeanProps = new Hashtable<String, Object>();
        mbeanProps.put("service.description", "Apache Sling FSClassLoader Controller Service");
        mbeanProps.put("service.vendor", "The Apache Software Foundation");
        mbeanProps.put("jmx.objectname", new ObjectName("org.apache.sling.classloader", jmxProps));
        mbeanRegistration = componentContext.getBundleContext().registerService(FSClassLoaderMBean.class.getName(), (Object)new FSClassLoaderMBeanImpl(this, componentContext.getBundleContext()), mbeanProps);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.root = null;
        this.rootURL = null;
        this.destroyClassLoader();
        if (classLoaderWriterServiceListener != null) {
            componentContext.getBundleContext().removeServiceListener(classLoaderWriterServiceListener);
        }
        if (mbeanRegistration != null) {
            mbeanRegistration.unregister();
            mbeanRegistration = null;
        }
    }

    private void destroyClassLoader() {
        FSDynamicClassLoader rcl = this.loader;
        if (rcl != null) {
            this.loader = null;
            ServiceReference<DynamicClassLoaderManager> localDynamicClassLoaderManager = this.dynamicClassLoaderManager;
            Bundle localCallerBundle = this.callerBundle;
            if (localDynamicClassLoaderManager != null && localCallerBundle != null) {
                try {
                    localCallerBundle.getBundleContext().ungetService(localDynamicClassLoaderManager);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        FSClassLoaderProvider fSClassLoaderProvider = this;
        synchronized (fSClassLoaderProvider) {
            if (this.loader == null || !this.loader.isLive()) {
                this.destroyClassLoader();
                DynamicClassLoaderManager dclm = (DynamicClassLoaderManager)this.callerBundle.getBundleContext().getService(this.dynamicClassLoaderManager);
                this.loader = new FSDynamicClassLoader(new URL[]{this.rootURL}, dclm.getDynamicClassLoader());
            }
            return this.loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClassLoader(String filePath) {
        if (filePath.endsWith(".class")) {
            String path = filePath.substring(this.root.getAbsolutePath().length() + 1, filePath.length() - 6);
            String className = path.replace(File.separatorChar, '.');
            FSClassLoaderProvider fSClassLoaderProvider = this;
            synchronized (fSClassLoaderProvider) {
                FSDynamicClassLoader currentLoader = this.loader;
                if (currentLoader != null) {
                    currentLoader.check(className);
                }
            }
        }
    }

    private boolean deleteRecursive(File f, List<String> names) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                if (this.deleteRecursive(c, names)) continue;
                return false;
            }
        }
        names.add(f.getAbsolutePath());
        return f.delete();
    }

    public boolean delete(String name) {
        String path = this.cleanPath(name);
        File file = new File(path);
        if (file.exists()) {
            ArrayList<String> names = new ArrayList<String>();
            boolean result = this.deleteRecursive(file, names);
            this.logger.debug("Deleted {} : {}", (Object)name, (Object)result);
            if (result) {
                for (String string : names) {
                    this.checkClassLoader(string);
                }
                for (ServiceReference serviceReference : this.classLoaderWriterListeners.values()) {
                    if (serviceReference == null) continue;
                    ClassLoaderWriterListener listener = (ClassLoaderWriterListener)this.callerBundle.getBundleContext().getService(serviceReference);
                    if (listener != null) {
                        listener.onClassLoaderClear(name);
                        continue;
                    }
                    this.logger.warn("Found ClassLoaderWriterListener Service reference with no service bound");
                }
            }
            return result;
        }
        return false;
    }

    public OutputStream getOutputStream(String name) {
        this.logger.debug("Get stream for {}", (Object)name);
        String path = this.cleanPath(name);
        File file = new File(path);
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try {
            if (file.exists()) {
                this.checkClassLoader(path);
            }
            return new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean rename(String oldName, String newName) {
        this.logger.debug("Rename {} to {}", (Object)oldName, (Object)newName);
        String oldPath = this.cleanPath(oldName);
        String newPath = this.cleanPath(newName);
        File old = new File(oldPath);
        boolean result = old.renameTo(new File(newPath));
        if (result) {
            this.checkClassLoader(oldPath);
            this.checkClassLoader(newPath);
        }
        return result;
    }

    private String cleanPath(String path) {
        path = path.replace('\\', '/');
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return this.root.getAbsolutePath() + path;
    }

    public InputStream getInputStream(String name) throws IOException {
        this.logger.debug("Get input stream of {}", (Object)name);
        String path = this.cleanPath(name);
        File file = new File(path);
        return new FileInputStream(file);
    }

    public long getLastModified(String name) {
        this.logger.debug("Get last modified of {}", (Object)name);
        String path = this.cleanPath(name);
        File file = new File(path);
        if (file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }
}

