/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.contentdetection.internal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

@Component
@Service(value={ContentAwareMimeTypeService.class})
@Properties(value={@Property(name="service.description", value={"Apache Sling Content Aware MIME Type Service"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="detection.mode", value={"tika"})})
public class ContentAwareMimeTypeServiceImpl
implements ContentAwareMimeTypeService {
    @Reference
    Detector detector;
    @Reference
    MimeTypeService mimeTypeService;

    @Override
    public String getMimeType(String filename, InputStream content) throws IOException, IllegalArgumentException {
        if (content == null) {
            return this.mimeTypeService.getMimeType(filename);
        }
        if (!content.markSupported()) {
            throw new IllegalArgumentException("Supplied InputStream does not support mark/reset");
        }
        TikaInputStream stream = TikaInputStream.get((InputStream)content);
        Metadata metadata = new Metadata();
        metadata.set("resourceName", filename);
        MediaType mediaType = this.detector.detect((InputStream)stream, metadata);
        return mediaType.toString();
    }

    public String getMimeType(String name) {
        return this.mimeTypeService.getMimeType(name);
    }

    public String getExtension(String mimeType) {
        return this.mimeTypeService.getExtension(mimeType);
    }

    public void registerMimeType(String mimeType, String ... extensions) {
        this.mimeTypeService.registerMimeType(mimeType, extensions);
    }

    public void registerMimeType(InputStream mimeTabStream) throws IOException {
        this.mimeTypeService.registerMimeType(mimeTabStream);
    }

    protected void bindDetector(Detector detector) {
        this.detector = detector;
    }

    protected void unbindDetector(Detector detector) {
        if (this.detector == detector) {
            this.detector = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

