/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.adapter.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sling.adapter.internal.AdapterFactoryDescriptor;
import org.apache.sling.adapter.internal.AdapterFactoryDescriptorKey;
import org.apache.sling.adapter.internal.AdapterFactoryDescriptorMap;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterManagerImpl
implements AdapterManager {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile ComponentContext context;
    private List<ServiceReference> boundAdapterFactories = new LinkedList<ServiceReference>();
    private Map<String, AdapterFactoryDescriptorMap> factories = new HashMap<String, AdapterFactoryDescriptorMap>();
    private Map<String, Map<String, AdapterFactory>> factoryCache;
    private EventAdmin eventAdmin;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Map<String, AdapterFactory> factories = this.getAdapterFactories(adaptable.getClass());
        AdapterFactory factory = factories.get(type.getName());
        if (factory != null) {
            this.log.debug("Using adapter factory {} to map {} to {}", new Object[]{factory, adaptable, type});
            return (AdapterType)factory.getAdapter(adaptable, type);
        }
        this.log.debug("No adapter factory found to map {} to {}", adaptable, type);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        ArrayList<ServiceReference> refs;
        this.context = context;
        List<ServiceReference> list = this.boundAdapterFactories;
        synchronized (list) {
            refs = new ArrayList<ServiceReference>(this.boundAdapterFactories);
            this.boundAdapterFactories.clear();
        }
        for (ServiceReference reference : refs) {
            this.registerAdapterFactory(context, reference);
        }
        SyntheticResource.setAdapterManager((AdapterManager)this);
    }

    protected void deactivate(ComponentContext context) {
        SyntheticResource.unsetAdapterManager((AdapterManager)this);
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindAdapterFactory(ServiceReference reference) {
        boolean create = true;
        if (this.context == null) {
            List<ServiceReference> list = this.boundAdapterFactories;
            synchronized (list) {
                if (this.context == null) {
                    this.boundAdapterFactories.add(reference);
                    create = false;
                }
            }
        }
        if (create) {
            this.registerAdapterFactory(this.context, reference);
        }
    }

    protected void unbindAdapterFactory(ServiceReference reference) {
        this.unregisterAdapterFactory(reference);
    }

    Map<String, AdapterFactoryDescriptorMap> getFactories() {
        return this.factories;
    }

    Map<String, Map<String, AdapterFactory>> getFactoryCache() {
        return this.factoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAdapterFactory(ComponentContext context, ServiceReference reference) {
        String[] adaptables = OsgiUtil.toStringArray((Object)reference.getProperty("adaptables"));
        String[] adapters = OsgiUtil.toStringArray((Object)reference.getProperty("adapters"));
        if (adaptables == null || adaptables.length == 0 || adapters == null || adapters.length == 0) {
            return;
        }
        AdapterFactoryDescriptorKey factoryKey = new AdapterFactoryDescriptorKey(reference);
        AdapterFactoryDescriptor factoryDesc = new AdapterFactoryDescriptor(context, reference, adapters);
        Map<String, AdapterFactoryDescriptorMap> map = this.factories;
        synchronized (map) {
            for (String adaptable : adaptables) {
                AdapterFactoryDescriptorMap adfMap = this.factories.get(adaptable);
                if (adfMap == null) {
                    adfMap = new AdapterFactoryDescriptorMap();
                    this.factories.put(adaptable, adfMap);
                }
                adfMap.put(factoryKey, factoryDesc);
            }
        }
        this.factoryCache = null;
        EventAdmin localEA = this.eventAdmin;
        if (localEA != null) {
            Hashtable<String, String[]> props = new Hashtable<String, String[]>();
            ((Dictionary)props).put("adaptables", adaptables);
            ((Dictionary)props).put("adapters", adapters);
            localEA.postEvent(new Event("org/apache/sling/api/adapter/AdapterFactory/ADDED", props));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAdapterFactory(ServiceReference reference) {
        EventAdmin localEA;
        List<ServiceReference> list = this.boundAdapterFactories;
        synchronized (list) {
            this.boundAdapterFactories.remove(reference);
        }
        String[] adaptables = OsgiUtil.toStringArray((Object)reference.getProperty("adaptables"));
        String[] adapters = OsgiUtil.toStringArray((Object)reference.getProperty("adapters"));
        if (adaptables == null || adaptables.length == 0 || adapters == null || adapters.length == 0) {
            return;
        }
        AdapterFactoryDescriptorKey factoryKey = new AdapterFactoryDescriptorKey(reference);
        boolean factoriesModified = false;
        Map<String, AdapterFactoryDescriptorMap> map = this.factories;
        synchronized (map) {
            for (String adaptable : adaptables) {
                AdapterFactoryDescriptorMap adfMap = this.factories.get(adaptable);
                if (adfMap == null) continue;
                factoriesModified |= adfMap.remove(factoryKey) != null;
                if (!adfMap.isEmpty()) continue;
                this.factories.remove(adaptable);
            }
        }
        if (factoriesModified) {
            this.factoryCache = null;
        }
        if ((localEA = this.eventAdmin) != null) {
            Hashtable<String, String[]> props = new Hashtable<String, String[]>();
            ((Dictionary)props).put("adaptables", adaptables);
            ((Dictionary)props).put("adapters", adapters);
            localEA.postEvent(new Event("org/apache/sling/api/adapter/AdapterFactory/REMOVED", props));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AdapterFactory> getAdapterFactories(Class<?> clazz) {
        Map<String, Map<String, AdapterFactory>> cache = this.factoryCache;
        if (cache == null) {
            this.factoryCache = cache = new HashMap<String, Map<String, AdapterFactory>>();
        }
        Map<String, Map<String, AdapterFactory>> map = cache;
        synchronized (map) {
            return this.getAdapterFactories(clazz, cache);
        }
    }

    private Map<String, AdapterFactory> getAdapterFactories(Class<?> clazz, Map<String, Map<String, AdapterFactory>> cache) {
        String className = clazz.getName();
        Map<String, AdapterFactory> entry = cache.get(className);
        if (entry == null) {
            entry = this.createAdapterFactoryMap(clazz, cache);
            cache.put(className, entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AdapterFactory> createAdapterFactoryMap(Class<?> clazz, Map<String, Map<String, AdapterFactory>> cache) {
        Class<?>[] interfaces;
        AdapterFactoryDescriptorMap afdMap;
        HashMap<String, AdapterFactory> afm = new HashMap<String, AdapterFactory>();
        Map<String, AdapterFactoryDescriptorMap> map = this.factories;
        synchronized (map) {
            afdMap = this.factories.get(clazz.getName());
        }
        if (afdMap != null) {
            for (AdapterFactoryDescriptor afd : afdMap.values()) {
                String[] adapters;
                for (String adapter : adapters = afd.getAdapters()) {
                    AdapterFactory factory;
                    if (afm.containsKey(adapter) || (factory = afd.getFactory()) == null) continue;
                    afm.put(adapter, factory);
                }
            }
        }
        for (Class<?> iFace : interfaces = clazz.getInterfaces()) {
            this.copyAdapterFactories(afm, iFace, cache);
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            this.copyAdapterFactories(afm, superClazz, cache);
        }
        return afm;
    }

    private void copyAdapterFactories(Map<String, AdapterFactory> dest, Class<?> clazz, Map<String, Map<String, AdapterFactory>> cache) {
        Map<String, AdapterFactory> scMap = this.getAdapterFactories(clazz, cache);
        for (Map.Entry<String, AdapterFactory> entry : scMap.entrySet()) {
            if (dest.containsKey(entry.getKey())) continue;
            dest.put(entry.getKey(), entry.getValue());
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

