/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.sling.maven.projectsupport.AbstractUsingBundleListMojo;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.io.xpp3.BundleListXpp3Writer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;

public class AttachBundleListMojo
extends AbstractUsingBundleListMojo {
    private File outputFile;
    private File configOutputDir;
    private ZipArchiver zipArchiver;
    private final BundleListXpp3Writer writer = new BundleListXpp3Writer();

    protected void executeWithArtifacts() throws MojoExecutionException, MojoFailureException {
        OutputStreamWriter fw = null;
        try {
            this.outputFile.getParentFile().mkdirs();
            fw = new FileWriter(this.outputFile);
            this.writer.write(fw, this.getInitializedBundleList());
            this.projectHelper.attachArtifact(this.project, "xml", "bundlelist", this.outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to output effective bundle list", (Exception)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {}
            }
        }
        this.getLog().info((CharSequence)"Attaching bundle list configuration");
        try {
            this.attachConfigurations();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to attach configuration.", (Exception)ioe);
        }
        catch (ArchiverException ioe) {
            throw new MojoExecutionException("Unable to attach configuration.", (Exception)((Object)ioe));
        }
    }

    private boolean checkFile(File f) {
        return f != null && f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachConfigurations() throws MojoExecutionException, IOException, ArchiverException {
        FileOutputStream fos;
        File slingDir;
        if (this.ignoreBundleListConfig) {
            this.getLog().debug((CharSequence)"ignoreBundleListConfig is set to true, therefore not attaching configurations.");
            return;
        }
        boolean hasConfigs = this.checkFile(this.getConfigDirectory());
        hasConfigs |= this.getSlingBootstrap(true) != null;
        hasConfigs |= this.getSlingBootstrap(false) != null;
        hasConfigs |= this.getSlingProperties(true) != null;
        if (!(hasConfigs |= this.getSlingProperties(false) != null)) {
            this.getLog().debug((CharSequence)"No configurations to attach.");
            return;
        }
        this.configOutputDir.mkdirs();
        if (this.getSlingBootstrap(false) != null) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            FileUtils.fileWrite((String)new File(slingDir, "webapp.bootstrap.txt").getAbsolutePath(), (String)"UTF-8", (String)this.getSlingBootstrap(false));
        }
        if (this.getSlingProperties(false) != null) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            fos = new FileOutputStream(new File(slingDir, "webapp.properties"));
            try {
                this.getSlingProperties(false).store(fos, null);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this.getSlingBootstrap(true) != null) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            FileUtils.fileWrite((String)new File(slingDir, "standalone.bootstrap.txt").getAbsolutePath(), (String)"UTF-8", (String)this.getSlingBootstrap(true));
        }
        if (this.getSlingProperties(true) != null) {
            slingDir = new File(this.configOutputDir, "sling");
            slingDir.mkdirs();
            fos = new FileOutputStream(new File(slingDir, "standalone.properties"));
            try {
                this.getSlingProperties(true).store(fos, null);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this.checkFile(this.getConfigDirectory())) {
            File configDir = new File(this.configOutputDir, "config");
            configDir.mkdirs();
            this.copyDirectory(this.getConfigDirectory(), configDir, null, FileUtils.getDefaultExcludes());
        }
        File destFile = new File(this.configOutputDir.getParent(), this.configOutputDir.getName() + ".zip");
        this.zipArchiver.setDestFile(destFile);
        this.zipArchiver.addDirectory(this.configOutputDir);
        this.zipArchiver.createArchive();
        this.projectHelper.attachArtifact(this.project, "zip", "bundlelistconfig", destFile);
    }
}

