/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.apache.sling.maven.projectsupport.AbstractBundleListMojo;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.BundleListUtils;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;

public abstract class AbstractUsingBundleListMojo
extends AbstractBundleListMojo {
    protected static final String JAR = "jar";
    protected static final String WAR = "war";
    protected static final String CONFIG_PATH_PREFIX = "resources/config";
    protected static final String BUNDLE_PATH_PREFIX = "resources/bundles";
    protected ArtifactDefinition defaultBundleList;
    private ArtifactDefinition[] additionalBundles;
    private BundleList initializedBundleList;
    private ArtifactDefinition[] bundleExclusions;
    private boolean includeDefaultBundles;
    private File[] rewriteRuleFiles;
    protected MavenFileFilter mavenFileFilter;
    private ZipUnArchiver zipUnarchiver;
    private Properties slingProperties;
    private Properties slingWebappProperties;
    private Properties slingStandaloneProperties;
    private String slingBootstrapCommand;
    private String slingWebappBootstrapCommand;
    private String slingStandaloneBootstrapCommand;
    private File tmpOutputDir;
    private File tempConfigDir;
    private File overlayConfigDir;

    protected static boolean shouldCopy(File source, File dest) {
        if (!dest.exists()) {
            return true;
        }
        return source.lastModified() > dest.lastModified();
    }

    public final void execute() throws MojoFailureException, MojoExecutionException {
        try {
            this.initBundleList();
            this.extractConfigurations();
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load dependency information from properties file.", e);
        }
        this.executeWithArtifacts();
    }

    protected File getConfigDirectory() {
        if (this.overlayConfigDir != null) {
            return this.overlayConfigDir;
        }
        return super.getConfigDirectory();
    }

    protected abstract void executeWithArtifacts() throws MojoExecutionException, MojoFailureException;

    protected BundleList getInitializedBundleList() {
        return this.initializedBundleList;
    }

    protected void initArtifactDefinitions(Properties dependencies) {
    }

    protected void initBundleList(BundleList bundleList) {
    }

    private final void initArtifactDefinitions() throws IOException {
        BundleListUtils.initArtifactDefinitions(((Object)((Object)this)).getClass().getClassLoader(), new BundleListUtils.ArtifactDefinitionsCallback(){

            public void initArtifactDefinitions(Properties dependencies) {
                if (AbstractUsingBundleListMojo.this.defaultBundleList == null) {
                    AbstractUsingBundleListMojo.this.defaultBundleList = new ArtifactDefinition();
                }
                AbstractUsingBundleListMojo.this.defaultBundleList.initDefaults(dependencies.getProperty("defaultBundleList"));
                AbstractUsingBundleListMojo.this.initArtifactDefinitions(dependencies);
            }
        });
    }

    private final void initBundleList() throws IOException, XmlPullParserException, MojoExecutionException {
        this.initArtifactDefinitions();
        if (BundleListUtils.isCurrentArtifact(this.project, this.defaultBundleList)) {
            this.initializedBundleList = BundleListUtils.readBundleList(this.bundleListFile);
        } else {
            this.initializedBundleList = new BundleList();
            if (this.includeDefaultBundles) {
                Artifact defBndListArtifact = this.getArtifact(this.defaultBundleList.getGroupId(), this.defaultBundleList.getArtifactId(), this.defaultBundleList.getVersion(), this.defaultBundleList.getType(), this.defaultBundleList.getClassifier());
                this.getLog().info((CharSequence)("Using bundle list file from " + defBndListArtifact.getFile().getAbsolutePath()));
                this.initializedBundleList = BundleListUtils.readBundleList(defBndListArtifact.getFile());
            }
            if (this.bundleListFile.exists()) {
                this.initializedBundleList.merge(BundleListUtils.readBundleList(this.bundleListFile));
            }
        }
        if (this.additionalBundles != null) {
            for (ArtifactDefinition def : this.additionalBundles) {
                this.initializedBundleList.add(def.toBundle());
            }
        }
        Set dependencies = this.project.getDependencyArtifacts();
        for (Artifact artifact : dependencies) {
            if (!"partialbundlelist".equals(artifact.getType())) continue;
            this.getLog().info((CharSequence)String.format("merging partial bundle list for %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
            this.initializedBundleList.merge(BundleListUtils.readBundleList(artifact.getFile()));
        }
        if (this.bundleExclusions != null) {
            for (ArtifactDefinition def : this.bundleExclusions) {
                this.initializedBundleList.remove(def.toBundle(), false);
            }
        }
        this.initBundleList(this.initializedBundleList);
        BundleListUtils.interpolateProperties(this.initializedBundleList, this.project, this.mavenSession);
        this.rewriteBundleList(this.initializedBundleList);
    }

    private final void extractConfigurations() throws MojoExecutionException, IOException {
        Set dependencies = this.project.getDependencyArtifacts();
        for (Artifact artifact : dependencies) {
            if (!"partialbundlelist".equals(artifact.getType())) continue;
            this.getLog().info((CharSequence)String.format("merging configuration from partial bundle list for %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
            this.extractConfiguration(artifact);
        }
    }

    private void extractConfiguration(Artifact artifact) throws MojoExecutionException, IOException {
        Artifact cfgArtifact = null;
        try {
            cfgArtifact = this.getArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "zip", "bundlelistconfig");
        }
        catch (MojoExecutionException ignore) {
            // empty catch block
        }
        if (cfgArtifact != null) {
            this.getLog().info((CharSequence)String.format("merging partial bundle list configuration for %s:%s:%s", cfgArtifact.getGroupId(), cfgArtifact.getArtifactId(), cfgArtifact.getVersion()));
            this.zipUnarchiver.setSourceFile(cfgArtifact.getFile());
            try {
                File configDir;
                this.tmpOutputDir.mkdirs();
                this.zipUnarchiver.setDestDirectory(this.tmpOutputDir);
                this.zipUnarchiver.extract();
                File slingDir = new File(this.tmpOutputDir, "sling");
                this.readSlingProperties(new File(slingDir, "common.properties"), 0);
                this.readSlingProperties(new File(slingDir, "webapp.properties"), 1);
                this.readSlingProperties(new File(slingDir, "standalone.properties"), 2);
                this.readSlingBootstrap(new File(slingDir, "common.bootstrap.txt"), 0);
                this.readSlingBootstrap(new File(slingDir, "webapp.bootstrap.txt"), 1);
                this.readSlingBootstrap(new File(slingDir, "standalone.bootstrap.txt"), 2);
                if (this.overlayConfigDir == null) {
                    this.tempConfigDir.mkdirs();
                    if (this.getConfigDirectory().exists()) {
                        FileUtils.copyDirectory((File)this.getConfigDirectory(), (File)this.tempConfigDir, null, (String)FileUtils.getDefaultExcludesAsString());
                    }
                    this.overlayConfigDir = this.tempConfigDir;
                }
                if ((configDir = new File(this.tmpOutputDir, "config")).exists()) {
                    FileUtils.copyDirectory((File)configDir, (File)this.tempConfigDir, null, (String)FileUtils.getDefaultExcludesAsString());
                }
            }
            catch (ArchiverException ae) {
                throw new MojoExecutionException("Unable to extract configuration archive.", (Exception)((Object)ae));
            }
            finally {
                FileUtils.deleteDirectory((File)this.tmpOutputDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteBundleList(BundleList bundleList) throws MojoExecutionException {
        if (this.rewriteRuleFiles != null) {
            KnowledgeBase knowledgeBase = this.createKnowledgeBase(this.rewriteRuleFiles);
            StatefulKnowledgeSession session = knowledgeBase.newStatefulKnowledgeSession();
            try {
                session.setGlobal("mavenSession", (Object)this.mavenSession);
                session.setGlobal("mavenProject", (Object)this.project);
                session.insert((Object)bundleList);
                session.fireAllRules();
            }
            finally {
                session.dispose();
            }
        }
    }

    private KnowledgeBase createKnowledgeBase(File[] files) throws MojoExecutionException {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newClassPathResource((String)"drools-globals.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        for (File file : files) {
            this.getLog().info((CharSequence)("Parsing rule file " + file.getAbsolutePath()));
            builder.add(ResourceFactory.newFileResource((File)file), ResourceType.DRL);
        }
        if (builder.hasErrors()) {
            this.getLog().error((CharSequence)"Rule errors:");
            for (KnowledgeBuilderError error : builder.getErrors()) {
                this.getLog().error((CharSequence)error.toString());
            }
            throw new MojoExecutionException("Unable to create rules. See log for details.");
        }
        KnowledgeBase base = KnowledgeBaseFactory.newKnowledgeBase();
        base.addKnowledgePackages(builder.getKnowledgePackages());
        return base;
    }

    private void copyProperties(Properties source, Properties dest) {
        Enumeration<Object> keys = source.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            dest.put(key, source.get(key));
        }
    }

    private void readSlingProperties(File propsFile, int mode) throws MojoExecutionException {
        if (propsFile.exists()) {
            File tmp = null;
            try {
                tmp = File.createTempFile("sling", "props");
                this.mavenFileFilter.copyFile(propsFile, tmp, true, this.project, null, true, System.getProperty("file.encoding"), this.mavenSession);
                Properties loadedProps = PropertyUtils.loadPropertyFile((File)tmp, null);
                if (mode == 0) {
                    if (this.slingProperties == null) {
                        this.slingProperties = loadedProps;
                    } else {
                        this.copyProperties(loadedProps, this.slingProperties);
                    }
                } else if (mode == 1) {
                    if (this.slingWebappProperties == null) {
                        this.slingWebappProperties = loadedProps;
                    } else {
                        this.copyProperties(loadedProps, this.slingWebappProperties);
                    }
                } else if (this.slingStandaloneProperties == null) {
                    this.slingStandaloneProperties = loadedProps;
                } else {
                    this.copyProperties(loadedProps, this.slingStandaloneProperties);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create filtered properties file", (Exception)e);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException("Unable to create filtered properties file", (Exception)((Object)e));
            }
            finally {
                if (tmp != null) {
                    tmp.delete();
                }
            }
        }
    }

    protected Properties getSlingProperties(boolean standalone) throws MojoExecutionException {
        Properties additionalProps;
        this.readSlingProperties(this.commonSlingProps, 0);
        Properties properties = additionalProps = standalone ? this.slingStandaloneProperties : this.slingWebappProperties;
        if (this.slingProperties == null) {
            return additionalProps;
        }
        if (additionalProps != null) {
            Properties combinedProps = new Properties();
            this.copyProperties(this.slingProperties, combinedProps);
            this.copyProperties(additionalProps, combinedProps);
            return combinedProps;
        }
        return this.slingProperties;
    }

    private void readSlingBootstrap(File bootstrapFile, int mode) throws MojoExecutionException {
        if (bootstrapFile.exists()) {
            File tmp = null;
            Reader reader = null;
            try {
                int l;
                tmp = File.createTempFile("sling", "bootstrap");
                this.mavenFileFilter.copyFile(bootstrapFile, tmp, true, this.project, null, true, System.getProperty("file.encoding"), this.mavenSession);
                reader = new FileReader(tmp);
                StringBuilder sb = new StringBuilder();
                if (mode == 0) {
                    if (this.slingBootstrapCommand != null) {
                        sb.append(this.slingBootstrapCommand);
                    }
                } else if (mode == 1) {
                    if (this.slingWebappBootstrapCommand != null) {
                        sb.append(this.slingWebappBootstrapCommand);
                    }
                } else if (this.slingStandaloneBootstrapCommand != null) {
                    sb.append(this.slingStandaloneBootstrapCommand);
                }
                char[] buffer = new char[2048];
                while ((l = reader.read(buffer, 0, buffer.length)) != -1) {
                    sb.append(buffer, 0, l);
                }
                sb.append('\n');
                if (mode == 0) {
                    this.slingBootstrapCommand = sb.toString();
                } else if (mode == 1) {
                    this.slingWebappBootstrapCommand = sb.toString();
                } else {
                    this.slingStandaloneBootstrapCommand = sb.toString();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create filtered bootstrap file", (Exception)e);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException("Unable to create filtered bootstrap file", (Exception)((Object)e));
            }
            finally {
                if (tmp != null) {
                    tmp.delete();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }

    protected String getSlingBootstrap(boolean standalone) throws MojoExecutionException {
        String addCmds;
        this.readSlingBootstrap(this.commonSlingBootstrap, 0);
        String string = addCmds = standalone ? this.slingStandaloneBootstrapCommand : this.slingWebappBootstrapCommand;
        if (this.slingBootstrapCommand == null) {
            return addCmds;
        }
        if (addCmds != null) {
            StringBuilder builder = new StringBuilder(this.slingBootstrapCommand);
            builder.append('\n');
            builder.append(addCmds);
            return builder.toString();
        }
        return this.slingBootstrapCommand;
    }
}

