/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.framework.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.apache.sling.launchpad.base.impl.ResourceProvider;
import org.apache.sling.launchpad.base.impl.Sling;
import org.apache.sling.launchpad.base.shared.Notifiable;
import org.apache.sling.maven.projectsupport.AbstractBundleListMojo;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLaunchpadStartingPlugin
extends AbstractBundleListMojo
implements Notifiable {
    private static final int DEFAULT_LOG_LEVEL = 3;
    private static final String[] logLevels = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG"};
    private static final String PROP_PORT = "org.osgi.service.http.port";
    private int httpPort;
    private ArtifactDefinition jarWebSupport;
    private String logLevel;
    private File propertiesFile;
    private MavenFileFilter mavenFileFilter;
    private MavenSession mavenSession;
    private ResourceProvider resourceProvider = new ResourceProvider(){

        public Iterator<String> getChildren(String path) {
            if (path.equals("resources/bundles")) {
                ArrayList<String> levels = new ArrayList<String>();
                for (StartLevel level : AbstractLaunchpadStartingPlugin.this.getBundleList().getStartLevels()) {
                    levels.add(String.valueOf(level.getLevel()) + "/");
                }
                return levels.iterator();
            }
            if (path.equals("resources/corebundles")) {
                List empty = Collections.emptyList();
                return empty.iterator();
            }
            try {
                int i = Integer.parseInt(path);
                ArrayList<String> bundles = new ArrayList<String>();
                for (StartLevel level : AbstractLaunchpadStartingPlugin.this.getBundleList().getStartLevels()) {
                    if (level.getLevel() != i) continue;
                    for (Bundle bundle : level.getBundles()) {
                        ArtifactDefinition d = new ArtifactDefinition(bundle, i);
                        try {
                            Artifact artifact = AbstractLaunchpadStartingPlugin.this.getArtifact(d);
                            bundles.add(artifact.getFile().toURI().toURL().toExternalForm());
                        }
                        catch (Exception e) {
                            AbstractLaunchpadStartingPlugin.this.getLog().error((CharSequence)"Unable to resolve artifact ", (Throwable)e);
                        }
                    }
                }
                return bundles.iterator();
            }
            catch (NumberFormatException e) {
                AbstractLaunchpadStartingPlugin.this.getLog().warn((CharSequence)("un-handlable path " + path));
                return null;
            }
        }

        public URL getResource(String path) {
            if (path.endsWith(".properties")) {
                return ((Object)((Object)this)).getClass().getResource("/" + path);
            }
            try {
                return new URL(path);
            }
            catch (MalformedURLException e) {
                AbstractLaunchpadStartingPlugin.this.getLog().error((CharSequence)"Expecting a real URL", (Throwable)e);
                return null;
            }
        }
    };
    private Sling sling;
    private String slingHome;
    private boolean forceBundleLoad;

    private static int toLogLevelInt(String level, int defaultLevel) {
        for (int i = 0; i < logLevels.length; ++i) {
            if (!logLevels[i].equalsIgnoreCase(level)) continue;
            return i;
        }
        return defaultLevel;
    }

    public void stopped() {
        this.sling = null;
    }

    public void updated(File tmpFile) {
        this.getLog().info((CharSequence)("File updated " + tmpFile.getAbsolutePath()));
    }

    @Override
    protected void executeWithArtifacts() throws MojoExecutionException, MojoFailureException {
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sling.home", this.slingHome);
            if (this.forceBundleLoad) {
                props.put("org.apache.sling.launchpad.force.package.bundle.loading", "true");
            }
            int logLevelNum = this.logLevel == null ? 3 : AbstractLaunchpadStartingPlugin.toLogLevelInt(this.logLevel, 3);
            props.put("felix.log.level", String.valueOf(logLevelNum));
            this.getLog().info((CharSequence)("HTTP server port: " + this.httpPort));
            props.put(PROP_PORT, String.valueOf(this.httpPort));
            Logger logger = new Logger();
            logger.setLogLevel(1);
            if (this.propertiesFile.exists()) {
                File tmp = null;
                try {
                    tmp = File.createTempFile("sling", "props");
                    this.mavenFileFilter.copyFile(this.propertiesFile, tmp, true, this.project, null, true, System.getProperty("file.encoding"), this.mavenSession);
                    Properties loadedProps = PropertyUtils.loadPropertyFile((File)tmp, null);
                    for (Object key : loadedProps.keySet()) {
                        props.put((String)key, (String)loadedProps.get(key));
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to create filtered properties file", (Exception)e);
                }
                catch (MavenFilteringException e) {
                    throw new MojoExecutionException("Unable to create filtered properties file", (Exception)((Object)e));
                }
                finally {
                    if (tmp != null) {
                        tmp.delete();
                    }
                }
            }
            this.sling = this.startSling(this.resourceProvider, props, logger);
        }
        catch (BundleException be) {
            this.getLog().error((CharSequence)"Failed to Start OSGi framework", (Throwable)be);
        }
    }

    protected abstract Sling startSling(ResourceProvider var1, Map<String, String> var2, Logger var3) throws BundleException;

    protected void stopSling() {
        if (this.sling != null) {
            this.sling.destroy();
        }
    }

    @Override
    protected void initArtifactDefinitions(Properties dependencies) {
        if (this.jarWebSupport == null) {
            this.jarWebSupport = new ArtifactDefinition();
        }
        this.jarWebSupport.initDefaults(dependencies.getProperty("jarWebSupport"));
    }

    @Override
    protected void initBundleList(BundleList bundleList) {
        bundleList.add(this.jarWebSupport.toBundle());
    }
}

