/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.maven.projectsupport.AbstractBundleListMojo;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractLaunchpadFrameworkMojo
extends AbstractBundleListMojo {
    protected String baseDestination;
    protected String bundlesDirectory;

    protected void copyBundles(BundleList bundles, File outputDirectory) throws MojoExecutionException {
        for (StartLevel startLevel : bundles.getStartLevels()) {
            for (Bundle bundle : startLevel.getBundles()) {
                this.copy(new ArtifactDefinition(bundle, startLevel.getLevel()), outputDirectory);
            }
        }
    }

    protected void copy(ArtifactDefinition additionalBundle, File outputDirectory) throws MojoExecutionException {
        Artifact artifact = this.getArtifact(additionalBundle);
        this.copy(artifact.getFile(), additionalBundle.getStartLevel(), outputDirectory);
    }

    protected void copy(File file, int startLevel, File outputDirectory) throws MojoExecutionException {
        File destination = new File(outputDirectory, String.format("%s/%s/%s/%s", this.baseDestination, this.bundlesDirectory, startLevel, file.getName()));
        if (AbstractLaunchpadFrameworkMojo.shouldCopy(file, destination)) {
            this.getLog().info((CharSequence)String.format("Copying bundle from %s to %s", file.getPath(), destination.getPath()));
            try {
                FileUtils.copyFile((File)file, (File)destination);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy bundle from " + file.getPath(), (Exception)e);
            }
        }
    }
}

