/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.sling.maven.projectsupport.AbstractLaunchpadFrameworkMojo;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class PreparePackageMojo
extends AbstractLaunchpadFrameworkMojo {
    private File warOutputDirectory;
    private String packaging;
    private ArtifactDefinition base;
    private ArtifactDefinition jarWebSupport;
    private File buildOutputDirectory;
    private ArchiverManager archiverManager;

    public void executeWithArtifacts() throws MojoExecutionException, MojoFailureException {
        this.copyBaseArtifact();
        this.copyBundles(this.getBundleList(), this.getOutputDirectory());
        this.copyConfigurationFiles();
        if ("jar".equals(this.packaging)) {
            this.unpackBaseArtifact();
        }
    }

    protected void initArtifactDefinitions(Properties dependencies) {
        if (this.base == null) {
            this.base = new ArtifactDefinition();
        }
        this.base.initDefaults(dependencies.getProperty("base"));
        if (this.jarWebSupport == null) {
            this.jarWebSupport = new ArtifactDefinition();
        }
        this.jarWebSupport.initDefaults(dependencies.getProperty("jarWebSupport"));
    }

    protected void initBundleList(BundleList bundleList) {
        if (this.packaging.equals("jar")) {
            bundleList.add(this.jarWebSupport.toBundle());
        }
    }

    private void copyBaseArtifact() throws MojoExecutionException {
        Artifact artifact = this.getBaseArtifact();
        if (artifact == null) {
            throw new MojoExecutionException(String.format("Project doesn't have a base dependency of groupId %s and artifactId %s", this.base.getGroupId(), this.base.getArtifactId()));
        }
        File destinationDir = new File(this.getOutputDirectory(), this.baseDestination);
        File destinationFile = new File(destinationDir, artifact.getArtifactId() + "." + artifact.getArtifactHandler().getExtension());
        if (PreparePackageMojo.shouldCopy(artifact.getFile(), destinationFile)) {
            try {
                this.getLog().info((CharSequence)String.format("Copying base artifact from %s to %s.", artifact.getFile(), destinationFile));
                FileUtils.copyFile((File)artifact.getFile(), (File)destinationFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy base artifact.", (Exception)e);
            }
        } else {
            this.getLog().debug((CharSequence)String.format("Skipping copy of base artifact from %s.", artifact.getFile()));
        }
    }

    private Artifact getBaseArtifact() throws MojoExecutionException {
        Artifact baseDependency = this.getBaseDependency();
        if (baseDependency == null) {
            return null;
        }
        return this.getArtifact(this.base.getGroupId(), this.base.getArtifactId(), baseDependency.getVersion(), this.base.getType(), this.base.getClassifier());
    }

    private Artifact getBaseDependency() {
        return (Artifact)this.project.getArtifactMap().get(this.base.getGroupId() + ":" + this.base.getArtifactId());
    }

    protected File getOutputDirectory() {
        if ("war".equals(this.packaging)) {
            return this.warOutputDirectory;
        }
        return this.buildOutputDirectory;
    }

    protected void unpackBaseArtifact() throws MojoExecutionException {
        Artifact artifact = this.getBaseDependency();
        if (artifact == null) {
            throw new MojoExecutionException(String.format("Project doesn't have a base dependency of groupId %s and artifactId %s", this.base.getGroupId(), this.base.getArtifactId()));
        }
        this.unpack(artifact.getFile(), this.buildOutputDirectory, null, null);
    }

    private void copyConfigurationFiles() throws MojoExecutionException {
        try {
            FileUtils.copyDirectory((File)this.configDirectory, (File)new File(this.getOutputDirectory(), "resources/config"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy configuration files", (Exception)e);
        }
    }

    private void unpack(File source, File destination, String includes, String excludes) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Unpacking " + source.getPath() + " to\n  " + destination.getPath()));
        try {
            destination.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(source);
            unArchiver.setSourceFile(source);
            unArchiver.setDestDirectory(destination);
            if (StringUtils.isNotEmpty((String)excludes) || StringUtils.isNotEmpty((String)includes)) {
                IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
                if (StringUtils.isNotEmpty((String)excludes)) {
                    selectors[0].setExcludes(excludes.split(","));
                }
                if (StringUtils.isNotEmpty((String)includes)) {
                    selectors[0].setIncludes(includes.split(","));
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
            }
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unable to find archiver for " + source.getPath(), (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to unpack " + source.getPath(), (Exception)((Object)e));
        }
    }
}

