/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.transport;

import java.util.HashMap;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.CommandExecutionProperties;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.Result;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class TracingCommand<T>
implements Command<T> {
    private final Command<T> command;
    private final EventAdmin eventAdmin;

    public static <T> TracingCommand<T> wrap(Command<T> command, EventAdmin eventAdmin) {
        return new TracingCommand<T>(command, eventAdmin);
    }

    public TracingCommand(Command<T> command, EventAdmin eventAdmin) {
        this.command = command;
        this.eventAdmin = eventAdmin;
    }

    @Override
    public Result<T> execute() {
        long start = System.currentTimeMillis();
        Result<T> result = this.command.execute();
        long end = System.currentTimeMillis();
        if (this.eventAdmin != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("result.txt", result.toString());
            try {
                result.get();
            }
            catch (RepositoryException e) {
                props.put("result.throwable", e);
            }
            props.put("action.type", this.command.getClass().getSimpleName());
            props.put("action.target", this.command.getPath());
            props.put("timestamp.start", start);
            props.put("timestamp.end", end);
            Event event = new Event(CommandExecutionProperties.REPOSITORY_TOPIC, props);
            this.eventAdmin.postEvent(event);
        }
        return result;
    }

    @Override
    public String getPath() {
        return this.command.getPath();
    }
}

