/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceProxy {
    private final String path;
    private final Map<String, Object> properties;
    private final List<ResourceProxy> children = new ArrayList<ResourceProxy>();
    private final Map<Class<?>, Object> adapted = new HashMap(1);

    public ResourceProxy(String path) {
        this(path, new HashMap<String, Object>());
    }

    public ResourceProxy(String path, Map<String, Object> properties) {
        this.path = path;
        this.properties = properties;
    }

    public void addChild(ResourceProxy child) {
        this.children.add(child);
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public String getPath() {
        return this.path;
    }

    public List<ResourceProxy> getChildren() {
        return this.children;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> void addAdapted(Class<T> klazz, T adaptedInstance) {
        this.adapted.put(klazz, adaptedInstance);
    }

    public <T> T adaptTo(Class<T> klazz) {
        Object res = this.adapted.get(klazz);
        return (T)res;
    }

    public List<ResourceProxy> getCoveredChildren() {
        ArrayList<ResourceProxy> coveredChildren = new ArrayList<ResourceProxy>();
        for (ResourceProxy child : this.getChildren()) {
            if (child.getProperties().isEmpty()) continue;
            coveredChildren.add(child);
        }
        return coveredChildren;
    }

    public boolean covers(String path) {
        for (ResourceProxy child : this.getCoveredChildren()) {
            if (!child.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('[').append(this.getClass().getSimpleName()).append(": path=").append(this.path).append(", properties=").append(this.properties);
        for (ResourceProxy child : this.children) {
            out.append("\n- ").append(child);
        }
        out.append("\n]");
        return out.toString();
    }
}

