/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.osgi.impl;

import java.io.InputStream;
import java.util.HashMap;
import org.apache.sling.ide.osgi.OsgiClient;
import org.apache.sling.ide.osgi.OsgiClientException;
import org.apache.sling.ide.transport.CommandExecutionProperties;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class TracingOsgiClient
implements OsgiClient {
    private final OsgiClient osgiClient;
    private final EventAdmin eventAdmin;

    public TracingOsgiClient(OsgiClient osgiClient, EventAdmin eventAdmin) {
        this.osgiClient = osgiClient;
        this.eventAdmin = eventAdmin;
    }

    @Override
    public Version getBundleVersion(String bundleSymbolicName) throws OsgiClientException {
        return this.osgiClient.getBundleVersion(bundleSymbolicName);
    }

    @Override
    public void installBundle(InputStream in, String fileName) throws OsgiClientException {
        this.osgiClient.installBundle(in, fileName);
    }

    @Override
    public void installLocalBundle(String explodedBundleLocation) throws OsgiClientException {
        this.logInstallLocalBundle(null, explodedBundleLocation);
    }

    private void logInstallLocalBundle(InputStream input, String explodedBundleLocation) throws OsgiClientException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        long start = System.currentTimeMillis();
        if (input != null) {
            props.put("action.type", "InstallJarredBundle");
        } else {
            props.put("action.type", "InstallLocalBundle");
        }
        props.put("action.target", explodedBundleLocation);
        props.put("timestamp.start", start);
        try {
            try {
                if (input != null) {
                    this.osgiClient.installLocalBundle(input, explodedBundleLocation);
                } else {
                    this.osgiClient.installLocalBundle(explodedBundleLocation);
                }
                props.put("result.txt", "OK");
            }
            catch (Throwable t) {
                props.put("result.txt", "FAILED");
                props.put("result.throwable", t);
                if (t instanceof OsgiClientException) {
                    throw (OsgiClientException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new Error(t);
            }
        }
        finally {
            props.put("timestamp.end", System.currentTimeMillis());
            Event event = new Event(CommandExecutionProperties.REPOSITORY_TOPIC, props);
            this.eventAdmin.postEvent(event);
        }
    }

    @Override
    public void installLocalBundle(InputStream jarredBundle, String sourceLocation) throws OsgiClientException {
        this.logInstallLocalBundle(jarredBundle, sourceLocation);
    }
}

