/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.osgi.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.apache.sling.ide.osgi.OsgiClient;
import org.apache.sling.ide.osgi.OsgiClientException;
import org.apache.sling.ide.transport.RepositoryInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class HttpOsgiClient
implements OsgiClient {
    private RepositoryInfo repositoryInfo;

    public HttpOsgiClient(RepositoryInfo repositoryInfo) {
        this.repositoryInfo = repositoryInfo;
    }

    @Override
    public Version getBundleVersion(String bundleSymbolicName) throws OsgiClientException {
        GetMethod method = new GetMethod(String.valueOf(this.repositoryInfo.getUrl()) + "system/console/bundles.json");
        HttpClient client = this.getHttpClient();
        try {
            int result = client.executeMethod((HttpMethod)method);
            if (result != 200) {
                throw new HttpException("Got status code " + result + " for call to " + method.getURI());
            }
            JSONObject object = new JSONObject(method.getResponseBodyAsString());
            JSONArray bundleData = object.getJSONArray("data");
            int i = 0;
            while (i < bundleData.length()) {
                JSONObject bundle = bundleData.getJSONObject(i);
                String remotebundleSymbolicName = bundle.getString("symbolicName");
                Version bundleVersion = new Version(bundle.getString("version"));
                if (bundleSymbolicName.equals(remotebundleSymbolicName)) {
                    Version version = bundleVersion;
                    return version;
                }
                ++i;
            }
            return null;
        }
        catch (HttpException e) {
            throw new OsgiClientException(e);
        }
        catch (IOException e) {
            throw new OsgiClientException(e);
        }
        catch (JSONException e) {
            throw new OsgiClientException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    private HttpClient getHttpClient() {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.repositoryInfo.getUsername(), this.repositoryInfo.getPassword());
        client.getState().setCredentials(new AuthScope(this.repositoryInfo.getHost(), this.repositoryInfo.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
        return client;
    }

    @Override
    public void installBundle(InputStream in, String fileName) throws OsgiClientException {
        if (in == null) {
            throw new IllegalArgumentException("in may not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName may not be null");
        }
        PostMethod filePost = new PostMethod(String.valueOf(this.repositoryInfo.getUrl()) + "system/console/install");
        try {
            try {
                filePost.setRequestHeader("referer", "about:blank");
                ArrayList<Object> partList = new ArrayList<Object>();
                partList.add(new StringPart("action", "install"));
                partList.add(new StringPart("_noredir_", "_noredir_"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)baos);
                ByteArrayPartSource partSource = new ByteArrayPartSource(fileName, baos.toByteArray());
                partList.add(new FilePart("bundlefile", (PartSource)partSource));
                partList.add(new StringPart("bundlestart", "start"));
                Part[] parts = partList.toArray(new Part[partList.size()]);
                filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
                int status = this.getHttpClient().executeMethod((HttpMethod)filePost);
                if (status != 200) {
                    throw new OsgiClientException("Method execution returned status " + status);
                }
            }
            catch (IOException e) {
                throw new OsgiClientException(e);
            }
        }
        finally {
            filePost.releaseConnection();
        }
    }

    @Override
    public void installLocalBundle(final String explodedBundleLocation) throws OsgiClientException {
        if (explodedBundleLocation == null) {
            throw new IllegalArgumentException("explodedBundleLocation may not be null");
        }
        new LocalBundleInstaller(this.getHttpClient(), this.repositoryInfo){

            @Override
            void configureRequest(PostMethod method) {
                method.addParameter("dir", explodedBundleLocation);
            }
        }.installBundle();
    }

    @Override
    public void installLocalBundle(final InputStream jarredBundle, String sourceLocation) throws OsgiClientException {
        if (jarredBundle == null) {
            throw new IllegalArgumentException("jarredBundle may not be null");
        }
        new LocalBundleInstaller(this.getHttpClient(), this.repositoryInfo){

            @Override
            void configureRequest(PostMethod method) throws IOException {
                Part[] parts = new Part[]{new FilePart("bundle", (PartSource)new ByteArrayPartSource("bundle.jar", IOUtils.toByteArray((InputStream)jarredBundle)))};
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
            }
        }.installBundle();
    }

    static abstract class LocalBundleInstaller {
        private final HttpClient httpClient;
        private final RepositoryInfo repositoryInfo;

        public LocalBundleInstaller(HttpClient httpClient, RepositoryInfo repositoryInfo) {
            this.httpClient = httpClient;
            this.repositoryInfo = repositoryInfo;
        }

        void installBundle() throws OsgiClientException {
            PostMethod method = new PostMethod(String.valueOf(this.repositoryInfo.getUrl()) + "system/sling/tooling/install");
            try {
                this.configureRequest(method);
                int status = this.httpClient.executeMethod((HttpMethod)method);
                if (status != 200) {
                    try {
                        JSONObject result = this.parseResult(method);
                        if (result.has("message")) {
                            throw new OsgiClientException(result.getString("message"));
                        }
                    }
                    catch (JSONException jSONException) {}
                    throw new OsgiClientException("Method execution returned status " + status);
                }
                JSONObject obj = this.parseResult(method);
                if ("OK".equals(obj.getString("status"))) {
                    return;
                }
                try {
                    String errorMessage = obj.has("message") ? "Bundle deployment failed, please check the Sling logs" : obj.getString("message");
                    throw new OsgiClientException(errorMessage);
                }
                catch (IOException e) {
                    throw new OsgiClientException(e);
                }
                catch (JSONException e) {
                    throw new OsgiClientException("Response is not valid JSON. The InstallServlet is probably not installed at the expected location", e);
                }
            }
            finally {
                method.releaseConnection();
            }
        }

        private JSONObject parseResult(PostMethod method) throws IOException, JSONException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)method.getResponseBodyAsStream(), (OutputStream)out);
            return new JSONObject(new String(out.toByteArray(), "UTF-8"));
        }

        abstract void configureRequest(PostMethod var1) throws IOException;
    }
}

