/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class IgnoredResources {
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public void registerRegExpIgnoreRule(String root, String pattern) {
        if (pattern.startsWith("#")) {
            return;
        }
        StringBuilder reg = new StringBuilder("^");
        if (root.equals("/")) {
            root = "";
        }
        reg.append(root).append("/");
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == '*') {
                reg.append(".*");
            } else if (c == '?') {
                reg.append(".");
            } else if (c == '.') {
                reg.append("\\.");
            } else {
                reg.append(c);
            }
            ++i;
        }
        reg.append("$");
        this.patterns.add(Pattern.compile(reg.toString()));
    }

    public boolean isIgnored(String repositoryPath) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(repositoryPath).matches()) continue;
            return true;
        }
        return false;
    }
}

