/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel.contrib;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.contrib.HSSFCellUtil;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.Region;

public final class HSSFRegionUtil {
    private HSSFRegionUtil() {
    }

    private static CellRangeAddress toCRA(Region region) {
        return Region.convertToCellRangeAddress((Region)region);
    }

    public static void setBorderLeft(short border, Region region, HSSFSheet sheet, HSSFWorkbook workbook) {
        HSSFRegionUtil.setBorderLeft((int)border, HSSFRegionUtil.toCRA(region), sheet, workbook);
    }

    public static void setBorderLeft(int border, CellRangeAddress region, HSSFSheet sheet, HSSFWorkbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getFirstColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderLeft", border);
        for (int i = rowStart; i <= rowEnd; ++i) {
            cps.setProperty(HSSFCellUtil.getRow(i, sheet), column);
        }
    }

    public static void setLeftBorderColor(short color, Region region, HSSFSheet sheet, HSSFWorkbook workbook) {
        HSSFRegionUtil.setLeftBorderColor((int)color, HSSFRegionUtil.toCRA(region), sheet, workbook);
    }

    public static void setLeftBorderColor(int color, CellRangeAddress region, HSSFSheet sheet, HSSFWorkbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getFirstColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "leftBorderColor", color);
        for (int i = rowStart; i <= rowEnd; ++i) {
            cps.setProperty(HSSFCellUtil.getRow(i, sheet), column);
        }
    }

    public static void setBorderRight(short border, Region region, HSSFSheet sheet, HSSFWorkbook workbook) {
        HSSFRegionUtil.setBorderRight((int)border, HSSFRegionUtil.toCRA(region), sheet, workbook);
    }

    public static void setBorderRight(int border, CellRangeAddress region, HSSFSheet sheet, HSSFWorkbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getLastColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderRight", border);
        for (int i = rowStart; i <= rowEnd; ++i) {
            cps.setProperty(HSSFCellUtil.getRow(i, sheet), column);
        }
    }

    public static void setRightBorderColor(short color, Region region, HSSFSheet sheet, HSSFWorkbook workbook) {
        HSSFRegionUtil.setRightBorderColor((int)color, HSSFRegionUtil.toCRA(region), sheet, workbook);
    }

    public static void setRightBorderColor(int color, CellRangeAddress region, HSSFSheet sheet, HSSFWorkbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getLastColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "rightBorderColor", color);
        for (int i = rowStart; i <= rowEnd; ++i) {
            cps.setProperty(HSSFCellUtil.getRow(i, sheet), column);
        }
    }

    public static void setBorderBottom(short border, Region region, HSSFSheet sheet, HSSFWorkbook workbook) {
        HSSFRegionUtil.setBorderBottom((int)border, HSSFRegionUtil.toCRA(region), sheet, workbook);
    }

    public static void setBorderBottom(int border, CellRangeAddress region, HSSFSheet sheet, HSSFWorkbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getLastRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderBottom", border);
        HSSFRow row = HSSFCellUtil.getRow(rowIndex, sheet);
        for (int i = colStart; i <= colEnd; ++i) {
            cps.setProperty(row, i);
        }
    }

    public static void setBottomBorderColor(short color, Region region, HSSFSheet sheet, HSSFWorkbook workbook) {
        HSSFRegionUtil.setBottomBorderColor((int)color, HSSFRegionUtil.toCRA(region), sheet, workbook);
    }

    public static void setBottomBorderColor(int color, CellRangeAddress region, HSSFSheet sheet, HSSFWorkbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getLastRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "bottomBorderColor", color);
        HSSFRow row = HSSFCellUtil.getRow(rowIndex, sheet);
        for (int i = colStart; i <= colEnd; ++i) {
            cps.setProperty(row, i);
        }
    }

    public static void setBorderTop(short border, Region region, HSSFSheet sheet, HSSFWorkbook workbook) {
        HSSFRegionUtil.setBorderTop((int)border, HSSFRegionUtil.toCRA(region), sheet, workbook);
    }

    public static void setBorderTop(int border, CellRangeAddress region, HSSFSheet sheet, HSSFWorkbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getFirstRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderTop", border);
        HSSFRow row = HSSFCellUtil.getRow(rowIndex, sheet);
        for (int i = colStart; i <= colEnd; ++i) {
            cps.setProperty(row, i);
        }
    }

    public static void setTopBorderColor(short color, Region region, HSSFSheet sheet, HSSFWorkbook workbook) {
        HSSFRegionUtil.setTopBorderColor((int)color, HSSFRegionUtil.toCRA(region), sheet, workbook);
    }

    public static void setTopBorderColor(int color, CellRangeAddress region, HSSFSheet sheet, HSSFWorkbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getFirstRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "topBorderColor", color);
        HSSFRow row = HSSFCellUtil.getRow(rowIndex, sheet);
        for (int i = colStart; i <= colEnd; ++i) {
            cps.setProperty(row, i);
        }
    }

    private static final class CellPropertySetter {
        private final HSSFWorkbook _workbook;
        private final String _propertyName;
        private final Short _propertyValue;

        public CellPropertySetter(HSSFWorkbook workbook, String propertyName, int value) {
            this._workbook = workbook;
            this._propertyName = propertyName;
            this._propertyValue = new Short((short)value);
        }

        public void setProperty(HSSFRow row, int column) {
            HSSFCell cell = HSSFCellUtil.getCell(row, column);
            HSSFCellUtil.setCellStyleProperty(cell, this._workbook, this._propertyName, this._propertyValue);
        }
    }
}

