/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractScriptedMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor {
    public List execute(MavenProject project, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        Map scriptFilesKeyedByBasedir = this.gatherScriptSourcesByBasedir(project.getScriptSourceRoots(), this.getScriptFileExtension());
        List mojoDescriptors = this.extractMojoDescriptors(scriptFilesKeyedByBasedir, pluginDescriptor);
        this.copyScriptsToOutputDirectory(scriptFilesKeyedByBasedir, project.getBuild().getOutputDirectory());
        return mojoDescriptors;
    }

    private void copyScriptsToOutputDirectory(Map scriptFilesKeyedByBasedir, String outputDirectory) throws ExtractionException {
        File outputDir = new File(outputDirectory);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        Iterator it = scriptFilesKeyedByBasedir.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            File sourceDir = new File((String)entry.getKey());
            Set scripts = (Set)entry.getValue();
            Iterator scriptIterator = scripts.iterator();
            while (scriptIterator.hasNext()) {
                File outputFile;
                File scriptFile = (File)scriptIterator.next();
                String relativePath = scriptFile.getPath().substring(sourceDir.getPath().length());
                if (relativePath.charAt(0) == File.separatorChar) {
                    relativePath = relativePath.substring(1);
                }
                if (!(outputFile = new File(outputDir, relativePath).getAbsoluteFile()).getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    in = new FileInputStream(scriptFile);
                    out = new FileOutputStream(outputFile);
                    byte[] buffer = new byte[16];
                    int read = -1;
                    while ((read = in.read(buffer)) > -1) {
                        out.write(buffer, 0, read);
                    }
                    out.flush();
                }
                catch (IOException e) {
                    try {
                        throw new ExtractionException("Cannot copy script file: " + scriptFile + " to output: " + outputFile, e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        IOUtil.close(out);
                        throw throwable;
                    }
                }
                IOUtil.close((InputStream)in);
                IOUtil.close((OutputStream)out);
            }
        }
    }

    protected abstract List extractMojoDescriptors(Map var1, PluginDescriptor var2) throws ExtractionException, InvalidPluginDescriptorException;

    protected abstract String getScriptFileExtension();

    protected Map gatherScriptSourcesByBasedir(List directories, String scriptFileExtension) {
        TreeMap sourcesByBasedir = new TreeMap();
        Iterator it = directories.iterator();
        while (it.hasNext()) {
            HashSet<File> sources = new HashSet<File>();
            String resourceDir = (String)it.next();
            File dir = new File(resourceDir).getAbsoluteFile();
            resourceDir = dir.getPath();
            if (!dir.exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(dir);
            scanner.addDefaultExcludes();
            scanner.scan();
            String[] relativePaths = scanner.getIncludedFiles();
            for (int i = 0; i < relativePaths.length; ++i) {
                String relativePath = relativePaths[i];
                File scriptFile = new File(dir, relativePath).getAbsoluteFile();
                if (!scriptFile.isFile() || !relativePath.endsWith(scriptFileExtension)) continue;
                sources.add(scriptFile);
            }
            sourcesByBasedir.put(resourceDir, sources);
        }
        return sourcesByBasedir;
    }
}

