/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.tools.plugin.generator.Generator;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PluginXdocGenerator
implements Generator {
    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        this.writeOverview(destinationDirectory, pluginDescriptor);
        Iterator it = pluginDescriptor.getMojos().iterator();
        while (it.hasNext()) {
            MojoDescriptor descriptor = (MojoDescriptor)it.next();
            this.processMojoDescriptor(descriptor, destinationDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, File destinationDirectory) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(destinationDirectory, this.getMojoFilename(mojoDescriptor, "xml")));
            this.writeBody(writer, mojoDescriptor);
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    private String getMojoFilename(MojoDescriptor mojo, String ext) {
        return mojo.getGoal() + "-mojo." + ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOverview(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(destinationDirectory, "index.xml"));
            this.writeOverview(writer, pluginDescriptor);
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    private void writeOverview(FileWriter writer, PluginDescriptor pluginDescriptor) {
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        w.startElement("document");
        w.startElement("properties");
        w.startElement("title");
        w.writeText(pluginDescriptor.getArtifactId() + " - Overview");
        w.endElement();
        w.endElement();
        w.startElement("body");
        w.startElement("section");
        w.addAttribute("name", pluginDescriptor.getArtifactId());
        w.startElement("p");
        w.writeText("Goals available: ");
        w.endElement();
        this.writeGoalTable(pluginDescriptor, (XMLWriter)w);
        w.endElement();
        w.endElement();
    }

    private void writeGoalTable(PluginDescriptor pluginDescriptor, XMLWriter w) {
        w.startElement("table");
        w.startElement("tr");
        w.startElement("th");
        w.writeText("Goal");
        w.endElement();
        w.startElement("th");
        w.writeText("Description");
        w.endElement();
        w.endElement();
        List mojos = pluginDescriptor.getMojos();
        Iterator i = mojos.iterator();
        while (i.hasNext()) {
            MojoDescriptor mojo = (MojoDescriptor)i.next();
            w.startElement("tr");
            w.startElement("td");
            String paramName = mojo.getFullGoalName();
            w.startElement("a");
            w.addAttribute("href", this.getMojoFilename(mojo, "html"));
            w.startElement("code");
            w.writeText(paramName);
            w.endElement();
            w.endElement();
            w.endElement();
            w.startElement("td");
            if (StringUtils.isNotEmpty((String)mojo.getDescription())) {
                w.writeMarkup(mojo.getDescription());
            } else {
                w.writeText("No description.");
            }
            String deprecationWarning = mojo.getDeprecated();
            if (deprecationWarning != null) {
                w.writeMarkup("<br/><b>Deprecated:</b> ");
                w.writeMarkup(deprecationWarning);
                if (deprecationWarning.length() == 0) {
                    w.writeText("No reason given.");
                }
                w.endElement();
            }
            w.endElement();
            w.endElement();
        }
        w.endElement();
        w.endElement();
    }

    private void writeBody(FileWriter writer, MojoDescriptor mojoDescriptor) {
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        w.startElement("document");
        w.startElement("properties");
        w.startElement("title");
        w.writeText(mojoDescriptor.getPluginDescriptor().getArtifactId() + " - " + mojoDescriptor.getFullGoalName());
        w.endElement();
        w.endElement();
        w.startElement("body");
        w.startElement("section");
        w.addAttribute("name", mojoDescriptor.getFullGoalName());
        w.startElement("p");
        if (mojoDescriptor.getDescription() != null) {
            w.writeMarkup(mojoDescriptor.getDescription());
        } else {
            w.writeText("No description.");
        }
        w.endElement();
        w.startElement("p");
        w.writeText("Parameters for the goal: ");
        w.endElement();
        this.writeGoalParameterTable(mojoDescriptor, (XMLWriter)w);
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private void writeGoalParameterTable(MojoDescriptor mojoDescriptor, XMLWriter w) {
        w.startElement("table");
        w.startElement("tr");
        w.startElement("th");
        w.writeText("Parameter");
        w.endElement();
        w.startElement("th");
        w.writeText("Type");
        w.endElement();
        w.startElement("th");
        w.writeText("Expression");
        w.endElement();
        w.startElement("th");
        w.writeText("Default Value");
        w.endElement();
        w.startElement("th");
        w.writeText("Description");
        w.endElement();
        w.endElement();
        List parameters = mojoDescriptor.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            w.startElement("tr");
            w.startElement("td");
            String paramName = parameter.getAlias();
            if (StringUtils.isEmpty((String)paramName)) {
                paramName = parameter.getName();
            }
            w.startElement("code");
            w.writeText(paramName);
            w.endElement();
            if (!parameter.isRequired()) {
                w.writeMarkup(" <i>(Optional)</i>");
            }
            if (parameter.getExpression() != null && parameter.getExpression().startsWith("${component.")) {
                w.writeMarkup(" <i>(Discovered)</i>");
            }
            w.endElement();
            w.startElement("td");
            w.startElement("code");
            w.addAttribute("title", parameter.getType());
            int index = parameter.getType().lastIndexOf(".");
            if (index >= 0) {
                w.writeText(parameter.getType().substring(index + 1));
            } else {
                w.writeText(parameter.getType());
            }
            w.endElement();
            w.endElement();
            w.startElement("td");
            w.startElement("code");
            if (StringUtils.isNotEmpty((String)parameter.getExpression()) && !parameter.getExpression().startsWith("${component.")) {
                w.writeText(parameter.getExpression());
            } else {
                w.writeText("-");
            }
            w.endElement();
            w.endElement();
            w.startElement("td");
            w.startElement("code");
            if (StringUtils.isNotEmpty((String)parameter.getDefaultValue())) {
                w.writeText(parameter.getDefaultValue());
            } else {
                w.writeText("-");
            }
            w.endElement();
            w.endElement();
            w.startElement("td");
            if (StringUtils.isNotEmpty((String)parameter.getDescription())) {
                w.writeMarkup(parameter.getDescription());
            } else {
                w.writeText("No description.");
            }
            String deprecationWarning = parameter.getDeprecated();
            if (deprecationWarning != null) {
                w.writeMarkup("<br/><b>Deprecated:</b> ");
                w.writeMarkup(deprecationWarning);
                if (deprecationWarning.length() == 0) {
                    w.writeText("No reason given.");
                }
            }
            w.endElement();
            w.endElement();
        }
        w.endElement();
    }
}

