/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PluginDescriptorGenerator
implements Generator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        File f = new File(destinationDirectory, "plugin.xml");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
            w.startElement("plugin");
            this.element((XMLWriter)w, "groupId", pluginDescriptor.getGroupId());
            this.element((XMLWriter)w, "artifactId", pluginDescriptor.getArtifactId());
            this.element((XMLWriter)w, "version", pluginDescriptor.getVersion());
            this.element((XMLWriter)w, "goalPrefix", pluginDescriptor.getGoalPrefix());
            this.element((XMLWriter)w, "isolatedRealm", "" + pluginDescriptor.isIsolatedRealm());
            this.element((XMLWriter)w, "inheritedByDefault", "" + pluginDescriptor.isInheritedByDefault());
            w.startElement("mojos");
            if (pluginDescriptor.getMojos() != null) {
                Iterator it = pluginDescriptor.getMojos().iterator();
                while (it.hasNext()) {
                    MojoDescriptor descriptor = (MojoDescriptor)it.next();
                    this.processMojoDescriptor(descriptor, (XMLWriter)w);
                }
            }
            w.endElement();
            PluginUtils.writeDependencies((XMLWriter)w, pluginDescriptor);
            w.endElement();
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, XMLWriter w) {
        String expression;
        Parameter parameter;
        w.startElement("mojo");
        w.startElement("goal");
        w.writeText(mojoDescriptor.getGoal());
        w.endElement();
        if (mojoDescriptor.isDependencyResolutionRequired() != null) {
            this.element(w, "requiresDependencyResolution", mojoDescriptor.isDependencyResolutionRequired());
        }
        this.element(w, "requiresProject", "" + mojoDescriptor.isProjectRequired());
        this.element(w, "requiresOnline", "" + mojoDescriptor.isOnlineRequired());
        this.element(w, "inheritedByDefault", "" + mojoDescriptor.isInheritedByDefault());
        if (mojoDescriptor.getPhase() != null) {
            this.element(w, "phase", mojoDescriptor.getPhase());
        }
        if (mojoDescriptor.getExecutePhase() != null) {
            this.element(w, "executePhase", mojoDescriptor.getExecutePhase());
        }
        if (mojoDescriptor.getExecuteLifecycle() != null) {
            this.element(w, "executeLifecycle", mojoDescriptor.getExecuteLifecycle());
        }
        w.startElement("implementation");
        w.writeText(mojoDescriptor.getImplementation());
        w.endElement();
        w.startElement("language");
        w.writeText(mojoDescriptor.getLanguage());
        w.endElement();
        if (mojoDescriptor.getComponentConfigurator() != null) {
            w.startElement("configurator");
            w.writeText(mojoDescriptor.getComponentConfigurator());
            w.endElement();
        }
        if (mojoDescriptor.getComponentComposer() != null) {
            w.startElement("composer");
            w.writeText(mojoDescriptor.getComponentComposer());
            w.endElement();
        }
        w.startElement("instantiationStrategy");
        w.writeText(mojoDescriptor.getInstantiationStrategy());
        w.endElement();
        w.startElement("executionStrategy");
        w.writeText(mojoDescriptor.getExecutionStrategy());
        w.endElement();
        List parameters = mojoDescriptor.getParameters();
        w.startElement("parameters");
        ArrayList<Parameter> requirements = new ArrayList<Parameter>();
        HashSet<Parameter> configuration = new HashSet<Parameter>();
        if (parameters != null) {
            for (int j = 0; j < parameters.size(); ++j) {
                parameter = (Parameter)parameters.get(j);
                expression = parameter.getExpression();
                if (StringUtils.isNotEmpty((String)expression) && expression.startsWith("${component.")) {
                    requirements.add(parameter);
                    continue;
                }
                w.startElement("parameter");
                this.element(w, "name", parameter.getName());
                if (parameter.getAlias() != null) {
                    this.element(w, "alias", parameter.getAlias());
                }
                this.element(w, "type", parameter.getType());
                if (parameter.getDeprecated() != null) {
                    this.element(w, "deprecated", parameter.getDeprecated());
                }
                this.element(w, "required", Boolean.toString(parameter.isRequired()));
                this.element(w, "editable", Boolean.toString(parameter.isEditable()));
                this.element(w, "description", parameter.getDescription());
                if (StringUtils.isNotEmpty((String)parameter.getDefaultValue()) || StringUtils.isNotEmpty((String)parameter.getExpression())) {
                    configuration.add(parameter);
                }
                w.endElement();
            }
        }
        w.endElement();
        if (!configuration.isEmpty()) {
            w.startElement("configuration");
            Iterator i = configuration.iterator();
            while (i.hasNext()) {
                parameter = (Parameter)i.next();
                w.startElement(parameter.getName());
                String type = parameter.getType();
                if (type != null) {
                    w.addAttribute("implementation", type);
                }
                if (parameter.getDefaultValue() != null) {
                    w.addAttribute("default-value", parameter.getDefaultValue());
                }
                if (parameter.getExpression() != null) {
                    w.writeText(parameter.getExpression());
                }
                w.endElement();
            }
            w.endElement();
        }
        if (!requirements.isEmpty()) {
            w.startElement("requirements");
            Iterator i = requirements.iterator();
            while (i.hasNext()) {
                Parameter requirement = (Parameter)i.next();
                w.startElement("requirement");
                expression = requirement.getExpression();
                String role = expression.substring("${component.".length(), expression.length() - 1);
                this.element(w, "role", role);
                this.element(w, "field-name", requirement.getName());
                w.endElement();
            }
            w.endElement();
        }
        w.endElement();
    }

    public void element(XMLWriter w, String name, String value) {
        w.startElement(name);
        if (value == null) {
            value = "";
        }
        w.writeText(value);
        w.endElement();
    }
}

