/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator.jelly;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JellyHarnessGenerator
implements Generator {
    protected String getClassName(MojoDescriptor pluginDescriptor) {
        return pluginDescriptor.getImplementation() + "Bean";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        PrettyPrintXMLWriter w;
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(destinationDirectory, "plugin.jelly"));
            w = new PrettyPrintXMLWriter((Writer)writer);
            this.writePluginFile(w, pluginDescriptor);
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
        writer = null;
        try {
            writer = new FileWriter(new File(destinationDirectory, "project.xml"));
            w = new PrettyPrintXMLWriter((Writer)writer);
            this.writeProjectFile(w, pluginDescriptor);
            writer.flush();
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private void writePluginFile(PrettyPrintXMLWriter w, PluginDescriptor pluginDescriptor) {
        MojoDescriptor descriptor;
        w.startElement("project");
        w.addAttribute("xmlns:j", "jelly:core");
        w.addAttribute("xmlns:d", "jelly:define");
        w.addAttribute("xmlns:" + pluginDescriptor.getGoalPrefix(), pluginDescriptor.getGoalPrefix());
        w.startElement("d:taglib");
        w.addAttribute("uri", pluginDescriptor.getGoalPrefix());
        Iterator it = pluginDescriptor.getMojos().iterator();
        while (it.hasNext()) {
            descriptor = (MojoDescriptor)it.next();
            this.processMojoDescriptor(descriptor, (XMLWriter)w);
        }
        w.endElement();
        it = pluginDescriptor.getMojos().iterator();
        while (it.hasNext()) {
            descriptor = (MojoDescriptor)it.next();
            this.writeGoals(descriptor, (XMLWriter)w);
        }
        w.endElement();
    }

    private void writeProjectFile(PrettyPrintXMLWriter w, PluginDescriptor pluginDescriptor) {
        w.startElement("project");
        w.startElement("dependencies");
        PluginUtils.writeDependencies((XMLWriter)w, pluginDescriptor);
        w.endElement();
        w.endElement();
    }

    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, XMLWriter w) {
        String goalName = mojoDescriptor.getGoal();
        w.startElement("d:jellybean");
        w.addAttribute("name", goalName + "Bean");
        w.addAttribute("className", this.getClassName(mojoDescriptor));
        w.addAttribute("method", "execute");
        w.endElement();
        w.startElement("d:tag");
        w.addAttribute("name", goalName);
        w.startElement(mojoDescriptor.getFullGoalName() + "Bean");
        List parameters = mojoDescriptor.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            String paramName = parameter.getAlias();
            if (StringUtils.isEmpty((String)paramName)) {
                paramName = parameter.getName();
            }
            w.addAttribute(paramName, "${" + paramName + "}");
        }
        w.endElement();
        w.endElement();
    }

    private void writeGoals(MojoDescriptor mojoDescriptor, XMLWriter w) {
        w.startElement("goal");
        w.addAttribute("name", mojoDescriptor.getFullGoalName());
        if (mojoDescriptor.getDescription() != null) {
            w.addAttribute("description", mojoDescriptor.getDescription());
        }
        w.startElement(mojoDescriptor.getFullGoalName() + "Bean");
        List goalParameters = mojoDescriptor.getParameters();
        for (int j = 0; j < goalParameters.size(); ++j) {
            Parameter p = (Parameter)goalParameters.get(j);
            String expression = p.getExpression();
            int projectIndex = expression.indexOf("project");
            if (projectIndex > 0) {
                expression = expression.substring(0, projectIndex) + "pom" + expression.substring(projectIndex + 7);
            }
            w.addAttribute(p.getName(), expression);
        }
        w.endElement();
        w.endElement();
    }

    protected String capitalise(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return new StringBuffer(str.length()).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }
}

