/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractScriptedMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor {
    public List execute(MavenProject project, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        Map scriptFilesKeyedByBasedir = this.gatherScriptSourcesByBasedir(project.getScriptSourceRoots(), this.getScriptFileExtension());
        List mojoDescriptors = this.extractMojoDescriptors(scriptFilesKeyedByBasedir, pluginDescriptor);
        return mojoDescriptors;
    }

    protected abstract List extractMojoDescriptors(Map var1, PluginDescriptor var2) throws ExtractionException, InvalidPluginDescriptorException;

    protected abstract String getScriptFileExtension();

    protected Map gatherScriptSourcesByBasedir(List directories, String scriptFileExtension) {
        TreeMap sourcesByBasedir = new TreeMap();
        Iterator it = directories.iterator();
        while (it.hasNext()) {
            HashSet<File> sources = new HashSet<File>();
            String resourceDir = (String)it.next();
            File dir = new File(resourceDir).getAbsoluteFile();
            resourceDir = dir.getPath();
            if (!dir.exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(dir);
            scanner.addDefaultExcludes();
            scanner.scan();
            String[] relativePaths = scanner.getIncludedFiles();
            for (int i = 0; i < relativePaths.length; ++i) {
                String relativePath = relativePaths[i];
                File scriptFile = new File(dir, relativePath).getAbsoluteFile();
                if (!scriptFile.isFile() || !relativePath.endsWith(scriptFileExtension)) continue;
                sources.add(scriptFile);
            }
            sourcesByBasedir.put(resourceDir, sources);
        }
        return sourcesByBasedir;
    }
}

