/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.util;

import java.util.Iterator;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public final class PluginUtils {
    private PluginUtils() {
    }

    private static void element(XMLWriter w, String name, String value) {
        w.startElement(name);
        if (value == null) {
            value = "";
        }
        w.writeText(value);
        w.endElement();
    }

    public static String[] findSources(String basedir, String include) {
        return PluginUtils.findSources(basedir, include, null);
    }

    public static String[] findSources(String basedir, String include, String exclude) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(basedir);
        scanner.setIncludes(new String[]{include});
        if (!StringUtils.isEmpty((String)exclude)) {
            scanner.setExcludes(new String[]{exclude});
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static String pluginId(MavenProject project) {
        String artifactId = project.getArtifactId();
        int firstHyphen = artifactId.indexOf("-");
        int lastHyphen = artifactId.lastIndexOf("-");
        String pluginId = artifactId.substring(firstHyphen + 1, lastHyphen);
        return pluginId;
    }

    public static void writeDependencies(XMLWriter w, MavenProject project) throws Exception {
        w.startElement("dependencies");
        Iterator it = project.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency dep = (Dependency)it.next();
            w.startElement("dependency");
            PluginUtils.element(w, "groupId", dep.getGroupId());
            PluginUtils.element(w, "artifactId", dep.getArtifactId());
            PluginUtils.element(w, "type", dep.getType());
            PluginUtils.element(w, "version", dep.getVersion());
            w.endElement();
        }
        w.endElement();
    }
}

