/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.scanner;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.scanner.MojoScanner;

public class DefaultMojoScanner
implements MojoScanner {
    private Map mojoDescriptorExtractors;

    public DefaultMojoScanner() {
    }

    public DefaultMojoScanner(Map extractors) {
        this.mojoDescriptorExtractors = extractors;
    }

    public Set execute(MavenProject project) throws Exception {
        HashSet descriptors = new HashSet();
        System.out.println("Using " + this.mojoDescriptorExtractors.size() + " extractors.");
        Iterator it = this.mojoDescriptorExtractors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String language = (String)entry.getKey();
            MojoDescriptorExtractor extractor = (MojoDescriptorExtractor)entry.getValue();
            System.out.println("Applying extractor for language: " + language);
            Set extractorDescriptors = extractor.execute(project);
            System.out.println("Extractor for language: " + language + " found " + extractorDescriptors.size() + " mojo descriptors.");
            descriptors.addAll(extractorDescriptors);
        }
        return descriptors;
    }
}

