/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator.jelly;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JellyHarnessGenerator
implements Generator {
    protected String capitalise(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return new StringBuffer(str.length()).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public void execute(String destinationDirectory, Set mojoDescriptors, MavenProject project) throws Exception {
        FileWriter writer = new FileWriter(new File(destinationDirectory, "plugin.jelly"));
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        String pluginId = PluginUtils.pluginId(project);
        w.startElement("project");
        w.addAttribute("xmlns:j", "jelly:core");
        w.addAttribute("xmlns:d", "jelly:define");
        w.addAttribute("xmlns:" + pluginId, pluginId);
        w.startElement("d:taglib");
        w.addAttribute("uri", pluginId);
        Iterator it = mojoDescriptors.iterator();
        while (it.hasNext()) {
            MojoDescriptor descriptor = (MojoDescriptor)it.next();
            this.processPluginDescriptor(descriptor, (XMLWriter)w, project);
        }
        w.endElement();
        Iterator it2 = mojoDescriptors.iterator();
        while (it2.hasNext()) {
            MojoDescriptor descriptor = (MojoDescriptor)it2.next();
            this.writeGoals(descriptor, (XMLWriter)w);
        }
        w.endElement();
        writer.flush();
        writer.close();
        writer = new FileWriter(new File(destinationDirectory, "project.xml"));
        w = new PrettyPrintXMLWriter((Writer)writer);
        w.startElement("project");
        w.startElement("dependencies");
        PluginUtils.writeDependencies((XMLWriter)w, project);
        w.endElement();
        w.endElement();
        writer.flush();
        writer.close();
    }

    protected String getClassName(MojoDescriptor pluginDescriptor) {
        return String.valueOf(pluginDescriptor.getImplementation()) + "Bean";
    }

    protected void processPluginDescriptor(MojoDescriptor mojoDescriptor, XMLWriter w, MavenProject project) throws Exception {
        String pluginId = PluginUtils.pluginId(project);
        String goalName = mojoDescriptor.getGoal();
        w.startElement("d:jellybean");
        w.addAttribute("name", String.valueOf(goalName) + "Bean");
        w.addAttribute("className", this.getClassName(mojoDescriptor));
        w.addAttribute("method", "execute");
        w.endElement();
        w.startElement("d:tag");
        w.addAttribute("name", goalName);
        w.startElement(String.valueOf(pluginId) + ":" + goalName + "Bean");
        List parameters = mojoDescriptor.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            Parameter parameter = (Parameter)parameters.get(i);
            w.addAttribute(parameter.getName(), "${" + parameter.getName() + "}");
            ++i;
        }
        w.endElement();
        w.endElement();
    }

    private void writeGoals(MojoDescriptor mojoDescriptor, XMLWriter w) {
        int j;
        String id = mojoDescriptor.getId();
        w.startElement("goal");
        w.addAttribute("name", String.valueOf(id) + ":" + mojoDescriptor.getGoal());
        List goalPrereqs = mojoDescriptor.getPrereqs();
        if (goalPrereqs.size() > 0) {
            StringBuffer prereqs = new StringBuffer();
            j = 0;
            while (j < goalPrereqs.size()) {
                String prereq = (String)goalPrereqs.get(j);
                prereqs.append(prereq);
                if (j < goalPrereqs.size() - 1) {
                    prereqs.append(",");
                }
                ++j;
            }
            w.addAttribute("prereqs", prereqs.toString());
        }
        if (mojoDescriptor.getDescription() != null) {
            w.addAttribute("description", mojoDescriptor.getDescription());
        }
        w.startElement(String.valueOf(id) + ":" + mojoDescriptor.getGoal() + "Bean");
        List goalParameters = mojoDescriptor.getParameters();
        j = 0;
        while (j < goalParameters.size()) {
            Parameter p = (Parameter)goalParameters.get(j);
            String expression = p.getExpression();
            int projectIndex = expression.indexOf("project");
            if (projectIndex > 0) {
                expression = String.valueOf(expression.substring(0, projectIndex)) + "pom" + expression.substring(projectIndex + 7);
            }
            if (expression.startsWith("#")) {
                expression = "${" + expression.substring(1) + "}";
            }
            w.addAttribute(p.getName(), expression);
            ++j;
        }
        w.endElement();
        w.endElement();
    }
}

