/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.generator.Generator;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PluginXdocGenerator
implements Generator {
    public void execute(String destinationDirectory, Set mojoDescriptors, MavenProject project) throws Exception {
        Iterator it = mojoDescriptors.iterator();
        while (it.hasNext()) {
            MojoDescriptor descriptor = (MojoDescriptor)it.next();
            this.processPluginDescriptor(descriptor, destinationDirectory);
        }
    }

    protected void processPluginDescriptor(MojoDescriptor mojoDescriptor, String destinationDirectory) throws Exception {
        String id = mojoDescriptor.getId();
        FileWriter writer = new FileWriter(new File(destinationDirectory, String.valueOf(id) + "-plugin.xml"));
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        w.startElement("document");
        w.startElement("properties");
        w.startElement("title");
        w.writeText("Documentation for the " + mojoDescriptor.getId() + " plugin.");
        w.endElement();
        w.startElement("author");
        w.addAttribute("email", "dev@maven.apache.org");
        w.writeText("Maven development team.");
        w.endElement();
        w.endElement();
        w.startElement("section");
        w.addAttribute("name", "Goals");
        w.startElement("p");
        w.writeText("The goals for the " + mojoDescriptor.getId() + " are as follows:");
        w.endElement();
        w.startElement("subsection");
        w.addAttribute("name", mojoDescriptor.getGoal());
        if (mojoDescriptor.getDescription() != null) {
            w.startElement("p");
            w.writeText(mojoDescriptor.getDescription());
            w.endElement();
        }
        w.startElement("p");
        w.writeText("These parameters for this goal: ");
        w.endElement();
        this.writeGoalParameterTable(mojoDescriptor, (XMLWriter)w);
        w.endElement();
        w.endElement();
        w.endElement();
        writer.flush();
        writer.close();
    }

    private void writeGoalParameterTable(MojoDescriptor mojoDescriptor, XMLWriter w) throws Exception {
        w.startElement("p");
        w.startElement("table");
        w.startElement("tr");
        w.startElement("th");
        w.writeText("Parameter");
        w.endElement();
        w.startElement("th");
        w.writeText("Expression");
        w.endElement();
        w.startElement("th");
        w.writeText("Description");
        w.endElement();
        w.endElement();
        List parameters = mojoDescriptor.getParameters();
        Map parameterMap = mojoDescriptor.getParameterMap();
        int i = 0;
        while (i < parameters.size()) {
            Parameter parameter = (Parameter)parameters.get(i);
            w.startElement("tr");
            w.startElement("td");
            w.writeText(parameter.getName());
            w.endElement();
            w.startElement("td");
            w.writeText(parameter.getExpression());
            w.endElement();
            w.startElement("td");
            Parameter p = (Parameter)parameterMap.get(parameter.getName());
            w.writeText(p.getDescription());
            w.endElement();
            w.endElement();
            ++i;
        }
        w.endElement();
        w.endElement();
    }
}

