/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PluginDescriptorGenerator
implements Generator {
    public void element(XMLWriter w, String name, String value) {
        w.startElement(name);
        if (value == null) {
            value = "";
        }
        w.writeText(value);
        w.endElement();
    }

    public void execute(String destinationDirectory, Set mavenMojoDescriptors, MavenProject project) throws Exception {
        File f = new File(destinationDirectory, "plugin.xml");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileWriter writer = new FileWriter(f);
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        w.startElement("plugin");
        this.element((XMLWriter)w, "id", PluginUtils.pluginId(project));
        this.element((XMLWriter)w, "isolatedRealm", "true");
        w.startElement("mojos");
        Iterator it = mavenMojoDescriptors.iterator();
        while (it.hasNext()) {
            MojoDescriptor descriptor = (MojoDescriptor)it.next();
            this.processPluginDescriptor(descriptor, (XMLWriter)w, project);
        }
        w.endElement();
        PluginUtils.writeDependencies((XMLWriter)w, project);
        w.endElement();
        writer.flush();
        writer.close();
    }

    protected void processPluginDescriptor(MojoDescriptor mojoDescriptor, XMLWriter w, MavenProject project) throws Exception {
        w.startElement("mojo");
        w.startElement("id");
        w.writeText(String.valueOf(mojoDescriptor.getId()) + ":" + mojoDescriptor.getGoal());
        w.endElement();
        if (mojoDescriptor.getRequiresDependencyResolution() != null) {
            this.element(w, "requiresDependencyResolution", mojoDescriptor.getRequiresDependencyResolution());
        }
        if (mojoDescriptor.getPhase() != null) {
            this.element(w, "phase", mojoDescriptor.getPhase());
        }
        w.startElement("implementation");
        w.writeText(mojoDescriptor.getImplementation());
        w.endElement();
        w.startElement("language");
        w.writeText(mojoDescriptor.getLanguage());
        w.endElement();
        w.startElement("instantiationStrategy");
        w.writeText(mojoDescriptor.getInstantiationStrategy());
        w.endElement();
        w.startElement("executionStrategy");
        w.writeText(mojoDescriptor.getExecutionStrategy());
        w.endElement();
        List parameters = mojoDescriptor.getParameters();
        w.startElement("parameters");
        int j = 0;
        while (j < parameters.size()) {
            Parameter parameter = (Parameter)parameters.get(j);
            w.startElement("parameter");
            this.element(w, "name", parameter.getName());
            this.element(w, "type", parameter.getType());
            this.element(w, "required", Boolean.toString(parameter.isRequired()));
            this.element(w, "validator", parameter.getValidator());
            this.element(w, "expression", parameter.getExpression());
            this.element(w, "description", parameter.getDescription());
            this.element(w, "default", parameter.getDefaultValue());
            w.endElement();
            ++j;
        }
        w.endElement();
        List prereqs = mojoDescriptor.getPrereqs();
        if (prereqs != null && prereqs.size() > 0) {
            w.startElement("prereqs");
            int j2 = 0;
            while (j2 < prereqs.size()) {
                this.element(w, "prereq", (String)prereqs.get(j2));
                ++j2;
            }
            w.endElement();
        }
        w.endElement();
    }
}

