/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.generator.Generator;
import org.codehaus.modello.generator.java.javasource.JClass;
import org.codehaus.modello.generator.java.javasource.JConstructor;
import org.codehaus.modello.generator.java.javasource.JMethod;
import org.codehaus.modello.generator.java.javasource.JParameter;
import org.codehaus.modello.generator.java.javasource.JSourceWriter;
import org.codehaus.modello.generator.java.javasource.JType;

public class BeanGenerator
implements Generator {
    protected String capitalise(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return new StringBuffer(str.length()).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    private JMethod createSetter(Parameter parameter, JClass jClass) {
        JClass parameterType;
        String propertyName = this.capitalise(parameter.getName());
        JMethod setter = new JMethod(null, "set" + propertyName);
        String type = parameter.getType();
        int arrayLocation = type.indexOf("[]");
        if (arrayLocation > 0) {
            type = type.substring(0, arrayLocation);
            parameterType = new JClass(type).createArray();
        } else {
            parameterType = new JClass(type);
        }
        setter.addParameter(new JParameter((JType)parameterType, parameter.getName()));
        setter.getSourceCode().add("addParameter( \"" + parameter.getName() + "\", " + parameter.getName() + " );");
        return setter;
    }

    public void execute(String destinationDirectory, Set mojoDescriptors, MavenProject project) throws Exception {
        Iterator it = mojoDescriptors.iterator();
        while (it.hasNext()) {
            MojoDescriptor descriptor = (MojoDescriptor)it.next();
            this.processPluginDescriptor(descriptor, destinationDirectory);
        }
    }

    protected void processPluginDescriptor(MojoDescriptor descriptor, String destinationDirectory) throws Exception {
        String implementation = descriptor.getImplementation();
        String className = String.valueOf(implementation.substring(implementation.lastIndexOf(".") + 1)) + "Bean";
        JClass jClass = new JClass(className);
        jClass.setSuperClass("org.apache.maven.plugin.BeanPluginAdapter");
        jClass.addImport("java.util.*");
        String packageName = implementation.substring(0, implementation.lastIndexOf("."));
        jClass.setPackageName(packageName);
        JConstructor constructor = new JConstructor(jClass);
        constructor.getSourceCode().add("super( new " + implementation + "() );");
        jClass.addConstructor(constructor);
        List parameters = descriptor.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            Parameter parameter = (Parameter)parameters.get(i);
            jClass.addMethod(this.createSetter(parameter, jClass));
            ++i;
        }
        String packageDirectory = this.replace(packageName, ".", "/", -1);
        File destination = new File(destinationDirectory, String.valueOf(packageDirectory) + "/" + className + ".java");
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        FileWriter writer = new FileWriter(destination);
        JSourceWriter sourceWriter = new JSourceWriter((Writer)writer);
        jClass.print(sourceWriter);
        writer.flush();
        writer.close();
    }

    protected String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max == 0) break;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }
}

