/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractScriptedMojoDescriptorExtractor
implements MojoDescriptorExtractor {
    public Set execute(MavenProject project) throws Exception {
        Map scriptFilesKeyedByBasedir = this.gatherScriptSourcesByBasedir(project.getScriptSourceRoots(), this.getScriptFileExtension());
        Set mojoDescriptors = this.extractMojoDescriptors(scriptFilesKeyedByBasedir);
        return mojoDescriptors;
    }

    protected abstract Set extractMojoDescriptors(Map var1) throws Exception;

    protected Map gatherScriptSourcesByBasedir(List directories, String scriptFileExtension) {
        TreeMap sourcesByBasedir = new TreeMap();
        Iterator it = directories.iterator();
        while (it.hasNext()) {
            HashSet<File> sources = new HashSet<File>();
            String resourceDir = (String)it.next();
            File dir = new File(resourceDir);
            if (!dir.exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(dir);
            scanner.addDefaultExcludes();
            scanner.scan();
            String[] relativePaths = scanner.getIncludedFiles();
            int i = 0;
            while (i < relativePaths.length) {
                String relativePath = relativePaths[i];
                File scriptFile = new File(dir, relativePath);
                if (scriptFile.isFile() && relativePath.endsWith(scriptFileExtension)) {
                    sources.add(scriptFile);
                }
                ++i;
            }
            sourcesByBasedir.put(resourceDir, sources);
        }
        return sourcesByBasedir;
    }

    protected abstract String getScriptFileExtension();
}

