/*
 * $Id$
 */

package org.apache.maven.plugin.registry;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class PluginRegistry.
 * 
 * @version $Revision$ $Date$
 */
public class PluginRegistry extends TrackableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field updateInterval
     */
    private String updateInterval = "never";

    /**
     * Field autoUpdate
     */
    private String autoUpdate;

    /**
     * Field plugins
     */
    private java.util.List plugins;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin
     * 
     * @param plugin
     */
    public void addPlugin(Plugin plugin)
    {
        getPlugins().add( plugin );
    } //-- void addPlugin(Plugin) 

    /**
     * Method getAutoUpdate
     */
    public String getAutoUpdate()
    {
        return this.autoUpdate;
    } //-- String getAutoUpdate() 

    /**
     * Method getPlugins
     */
    public java.util.List getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList();
        }
        
        return this.plugins;
    } //-- java.util.List getPlugins() 

    /**
     * Method getUpdateInterval
     */
    public String getUpdateInterval()
    {
        return this.updateInterval;
    } //-- String getUpdateInterval() 

    /**
     * Method removePlugin
     * 
     * @param plugin
     */
    public void removePlugin(Plugin plugin)
    {
        getPlugins().remove( plugin );
    } //-- void removePlugin(Plugin) 

    /**
     * Method setAutoUpdate
     * 
     * @param autoUpdate
     */
    public void setAutoUpdate(String autoUpdate)
    {
        this.autoUpdate = autoUpdate;
    } //-- void setAutoUpdate(String) 

    /**
     * Method setPlugins
     * 
     * @param plugins
     */
    public void setPlugins(java.util.List plugins)
    {
        this.plugins = plugins;
    } //-- void setPlugins(java.util.List) 

    /**
     * Method setUpdateInterval
     * 
     * @param updateInterval
     */
    public void setUpdateInterval(String updateInterval)
    {
        this.updateInterval = updateInterval;
    } //-- void setUpdateInterval(String) 


    private Map pluginsByKey;
    
    public Map getPluginsByKey()
    {
        if ( pluginsByKey == null )
        {
            pluginsByKey = new HashMap();
            
            for ( Iterator it = getPlugins().iterator(); it.hasNext(); )
            {
                Plugin plugin = (Plugin) it.next();
            
                pluginsByKey.put( plugin.getKey(), plugin );
            }
        }
        
        return pluginsByKey;
    }
    
    public void flushPluginsByKey()
    {
        this.pluginsByKey = null;
    }
    
    private RuntimeInfo runtimeInfo;
    
    public void setRuntimeInfo( RuntimeInfo runtimeInfo )
    {
        this.runtimeInfo = runtimeInfo;
    }
    
    public RuntimeInfo getRuntimeInfo()
    {
        return runtimeInfo;
    }
        }
