/*
 * $Id$
 */

package org.apache.maven.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Goal;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.*;
import org.codehaus.plexus.util.xml.pull.*;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class MavenXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class MavenXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field serializer
     */
    private org.codehaus.plexus.util.xml.pull.XmlSerializer serializer;

    /**
     * Field NAMESPACE
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param project
     */
    public void write(Writer writer, Model project)
        throws java.io.IOException
    {
        serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        writeModel( project, "project", serializer );
    } //-- void write(Writer, Model) 

    /**
     * Method writeActivation
     * 
     * @param activation
     * @param serializer
     * @param tagName
     */
    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( activation != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( activation.getJdk() != null )
            {
                serializer.startTag( NAMESPACE, "jdk" ).text( activation.getJdk() ).endTag( NAMESPACE, "jdk" );
            }
            if ( activation.getProperty() != null )
            {
                writeActivationProperty( activation.getProperty(), "property", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeActivation(Activation, String, XmlSerializer) 

    /**
     * Method writeActivationProperty
     * 
     * @param activationProperty
     * @param serializer
     * @param tagName
     */
    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( activationProperty != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( activationProperty.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( activationProperty.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( activationProperty.getValue() != null )
            {
                serializer.startTag( NAMESPACE, "value" ).text( activationProperty.getValue() ).endTag( NAMESPACE, "value" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeActivationProperty(ActivationProperty, String, XmlSerializer) 

    /**
     * Method writeBuild
     * 
     * @param build
     * @param serializer
     * @param tagName
     */
    private void writeBuild(Build build, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( build != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( build.getSourceDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "sourceDirectory" ).text( build.getSourceDirectory() ).endTag( NAMESPACE, "sourceDirectory" );
            }
            if ( build.getScriptSourceDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "scriptSourceDirectory" ).text( build.getScriptSourceDirectory() ).endTag( NAMESPACE, "scriptSourceDirectory" );
            }
            if ( build.getTestSourceDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "testSourceDirectory" ).text( build.getTestSourceDirectory() ).endTag( NAMESPACE, "testSourceDirectory" );
            }
            if ( build.getDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "directory" ).text( build.getDirectory() ).endTag( NAMESPACE, "directory" );
            }
            if ( build.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( build.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( build.getTestOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "testOutputDirectory" ).text( build.getTestOutputDirectory() ).endTag( NAMESPACE, "testOutputDirectory" );
            }
            if ( build.getDefaultGoal() != null )
            {
                serializer.startTag( NAMESPACE, "defaultGoal" ).text( build.getDefaultGoal() ).endTag( NAMESPACE, "defaultGoal" );
            }
            if ( build.getResources() != null && build.getResources().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "resources" );
                for ( Iterator iter = build.getResources().iterator(); iter.hasNext(); )
                {
                    Resource resource = (Resource) iter.next();
                    writeResource( resource, "resource", serializer );
                }
                serializer.endTag( NAMESPACE, "resources" );
            }
            if ( build.getTestResources() != null && build.getTestResources().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "testResources" );
                for ( Iterator iter = build.getTestResources().iterator(); iter.hasNext(); )
                {
                    Resource resource = (Resource) iter.next();
                    writeResource( resource, "testResource", serializer );
                }
                serializer.endTag( NAMESPACE, "testResources" );
            }
            if ( build.getFinalName() != null )
            {
                serializer.startTag( NAMESPACE, "finalName" ).text( build.getFinalName() ).endTag( NAMESPACE, "finalName" );
            }
            if ( build.getPluginManagement() != null )
            {
                writePluginManagement( build.getPluginManagement(), "pluginManagement", serializer );
            }
            if ( build.getPlugins() != null && build.getPlugins().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "plugins" );
                for ( Iterator iter = build.getPlugins().iterator(); iter.hasNext(); )
                {
                    Plugin plugin = (Plugin) iter.next();
                    writePlugin( plugin, "plugin", serializer );
                }
                serializer.endTag( NAMESPACE, "plugins" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeBuild(Build, String, XmlSerializer) 

    /**
     * Method writeBuildBase
     * 
     * @param buildBase
     * @param serializer
     * @param tagName
     */
    private void writeBuildBase(BuildBase buildBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( buildBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( buildBase.getDefaultGoal() != null )
            {
                serializer.startTag( NAMESPACE, "defaultGoal" ).text( buildBase.getDefaultGoal() ).endTag( NAMESPACE, "defaultGoal" );
            }
            if ( buildBase.getResources() != null && buildBase.getResources().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "resources" );
                for ( Iterator iter = buildBase.getResources().iterator(); iter.hasNext(); )
                {
                    Resource resource = (Resource) iter.next();
                    writeResource( resource, "resource", serializer );
                }
                serializer.endTag( NAMESPACE, "resources" );
            }
            if ( buildBase.getTestResources() != null && buildBase.getTestResources().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "testResources" );
                for ( Iterator iter = buildBase.getTestResources().iterator(); iter.hasNext(); )
                {
                    Resource resource = (Resource) iter.next();
                    writeResource( resource, "testResource", serializer );
                }
                serializer.endTag( NAMESPACE, "testResources" );
            }
            if ( buildBase.getFinalName() != null )
            {
                serializer.startTag( NAMESPACE, "finalName" ).text( buildBase.getFinalName() ).endTag( NAMESPACE, "finalName" );
            }
            if ( buildBase.getPluginManagement() != null )
            {
                writePluginManagement( buildBase.getPluginManagement(), "pluginManagement", serializer );
            }
            if ( buildBase.getPlugins() != null && buildBase.getPlugins().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "plugins" );
                for ( Iterator iter = buildBase.getPlugins().iterator(); iter.hasNext(); )
                {
                    Plugin plugin = (Plugin) iter.next();
                    writePlugin( plugin, "plugin", serializer );
                }
                serializer.endTag( NAMESPACE, "plugins" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeBuildBase(BuildBase, String, XmlSerializer) 

    /**
     * Method writeCiManagement
     * 
     * @param ciManagement
     * @param serializer
     * @param tagName
     */
    private void writeCiManagement(CiManagement ciManagement, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( ciManagement != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( ciManagement.getSystem() != null )
            {
                serializer.startTag( NAMESPACE, "system" ).text( ciManagement.getSystem() ).endTag( NAMESPACE, "system" );
            }
            if ( ciManagement.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( ciManagement.getUrl() ).endTag( NAMESPACE, "url" );
            }
            if ( ciManagement.getNotifiers() != null && ciManagement.getNotifiers().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "notifiers" );
                for ( Iterator iter = ciManagement.getNotifiers().iterator(); iter.hasNext(); )
                {
                    Notifier notifier = (Notifier) iter.next();
                    writeNotifier( notifier, "notifier", serializer );
                }
                serializer.endTag( NAMESPACE, "notifiers" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeCiManagement(CiManagement, String, XmlSerializer) 

    /**
     * Method writeConfigurationContainer
     * 
     * @param configurationContainer
     * @param serializer
     * @param tagName
     */
    private void writeConfigurationContainer(ConfigurationContainer configurationContainer, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( configurationContainer != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( configurationContainer.getInherited() != null )
            {
                serializer.startTag( NAMESPACE, "inherited" ).text( configurationContainer.getInherited() ).endTag( NAMESPACE, "inherited" );
            }
            if ( configurationContainer.getConfiguration() != null )
            {
                ((Xpp3Dom) configurationContainer.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeConfigurationContainer(ConfigurationContainer, String, XmlSerializer) 

    /**
     * Method writeContributor
     * 
     * @param contributor
     * @param serializer
     * @param tagName
     */
    private void writeContributor(Contributor contributor, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( contributor != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( contributor.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( contributor.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( contributor.getEmail() != null )
            {
                serializer.startTag( NAMESPACE, "email" ).text( contributor.getEmail() ).endTag( NAMESPACE, "email" );
            }
            if ( contributor.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( contributor.getUrl() ).endTag( NAMESPACE, "url" );
            }
            if ( contributor.getOrganization() != null )
            {
                serializer.startTag( NAMESPACE, "organization" ).text( contributor.getOrganization() ).endTag( NAMESPACE, "organization" );
            }
            if ( contributor.getOrganizationUrl() != null )
            {
                serializer.startTag( NAMESPACE, "organizationUrl" ).text( contributor.getOrganizationUrl() ).endTag( NAMESPACE, "organizationUrl" );
            }
            if ( contributor.getRoles() != null && contributor.getRoles().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "roles" );
                for ( Iterator iter = contributor.getRoles().iterator(); iter.hasNext(); )
                {
                    String role = (String) iter.next();
                    serializer.startTag( NAMESPACE, "role" ).text( role ).endTag( NAMESPACE, "role" );
                }
                serializer.endTag( NAMESPACE, "roles" );
            }
            if ( contributor.getTimezone() != null )
            {
                serializer.startTag( NAMESPACE, "timezone" ).text( contributor.getTimezone() ).endTag( NAMESPACE, "timezone" );
            }
            if ( contributor.getProperties() != null && contributor.getProperties().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "properties" );
                for ( Iterator iter = contributor.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) contributor.getProperties().get( key );
                    serializer.startTag( NAMESPACE, "" + key + "" ).text( value ).endTag( NAMESPACE, "" + key + "" );
                }
                serializer.endTag( NAMESPACE, "properties" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeContributor(Contributor, String, XmlSerializer) 

    /**
     * Method writeDependency
     * 
     * @param dependency
     * @param serializer
     * @param tagName
     */
    private void writeDependency(Dependency dependency, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( dependency != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( dependency.getGroupId() != null )
            {
                serializer.startTag( NAMESPACE, "groupId" ).text( dependency.getGroupId() ).endTag( NAMESPACE, "groupId" );
            }
            if ( dependency.getArtifactId() != null )
            {
                serializer.startTag( NAMESPACE, "artifactId" ).text( dependency.getArtifactId() ).endTag( NAMESPACE, "artifactId" );
            }
            if ( dependency.getVersion() != null )
            {
                serializer.startTag( NAMESPACE, "version" ).text( dependency.getVersion() ).endTag( NAMESPACE, "version" );
            }
            if ( dependency.getType() != null && !dependency.getType().equals( "jar" ) )
            {
                serializer.startTag( NAMESPACE, "type" ).text( dependency.getType() ).endTag( NAMESPACE, "type" );
            }
            if ( dependency.getScope() != null && !dependency.getScope().equals( "compile" ) )
            {
                serializer.startTag( NAMESPACE, "scope" ).text( dependency.getScope() ).endTag( NAMESPACE, "scope" );
            }
            if ( dependency.getExclusions() != null && dependency.getExclusions().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "exclusions" );
                for ( Iterator iter = dependency.getExclusions().iterator(); iter.hasNext(); )
                {
                    Exclusion exclusion = (Exclusion) iter.next();
                    writeExclusion( exclusion, "exclusion", serializer );
                }
                serializer.endTag( NAMESPACE, "exclusions" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDependency(Dependency, String, XmlSerializer) 

    /**
     * Method writeDependencyManagement
     * 
     * @param dependencyManagement
     * @param serializer
     * @param tagName
     */
    private void writeDependencyManagement(DependencyManagement dependencyManagement, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( dependencyManagement != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( dependencyManagement.getDependencies() != null && dependencyManagement.getDependencies().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "dependencies" );
                for ( Iterator iter = dependencyManagement.getDependencies().iterator(); iter.hasNext(); )
                {
                    Dependency dependency = (Dependency) iter.next();
                    writeDependency( dependency, "dependency", serializer );
                }
                serializer.endTag( NAMESPACE, "dependencies" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDependencyManagement(DependencyManagement, String, XmlSerializer) 

    /**
     * Method writeDeveloper
     * 
     * @param developer
     * @param serializer
     * @param tagName
     */
    private void writeDeveloper(Developer developer, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( developer != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( developer.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( developer.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( developer.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( developer.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( developer.getEmail() != null )
            {
                serializer.startTag( NAMESPACE, "email" ).text( developer.getEmail() ).endTag( NAMESPACE, "email" );
            }
            if ( developer.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( developer.getUrl() ).endTag( NAMESPACE, "url" );
            }
            if ( developer.getOrganization() != null )
            {
                serializer.startTag( NAMESPACE, "organization" ).text( developer.getOrganization() ).endTag( NAMESPACE, "organization" );
            }
            if ( developer.getOrganizationUrl() != null )
            {
                serializer.startTag( NAMESPACE, "organizationUrl" ).text( developer.getOrganizationUrl() ).endTag( NAMESPACE, "organizationUrl" );
            }
            if ( developer.getRoles() != null && developer.getRoles().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "roles" );
                for ( Iterator iter = developer.getRoles().iterator(); iter.hasNext(); )
                {
                    String role = (String) iter.next();
                    serializer.startTag( NAMESPACE, "role" ).text( role ).endTag( NAMESPACE, "role" );
                }
                serializer.endTag( NAMESPACE, "roles" );
            }
            if ( developer.getTimezone() != null )
            {
                serializer.startTag( NAMESPACE, "timezone" ).text( developer.getTimezone() ).endTag( NAMESPACE, "timezone" );
            }
            if ( developer.getProperties() != null && developer.getProperties().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "properties" );
                for ( Iterator iter = developer.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) developer.getProperties().get( key );
                    serializer.startTag( NAMESPACE, "" + key + "" ).text( value ).endTag( NAMESPACE, "" + key + "" );
                }
                serializer.endTag( NAMESPACE, "properties" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDeveloper(Developer, String, XmlSerializer) 

    /**
     * Method writeDistributionManagement
     * 
     * @param distributionManagement
     * @param serializer
     * @param tagName
     */
    private void writeDistributionManagement(DistributionManagement distributionManagement, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( distributionManagement != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( distributionManagement.getRepository() != null )
            {
                writeRepository( distributionManagement.getRepository(), "repository", serializer );
            }
            if ( distributionManagement.getSite() != null )
            {
                writeSite( distributionManagement.getSite(), "site", serializer );
            }
            if ( distributionManagement.getDownloadUrl() != null )
            {
                serializer.startTag( NAMESPACE, "downloadUrl" ).text( distributionManagement.getDownloadUrl() ).endTag( NAMESPACE, "downloadUrl" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDistributionManagement(DistributionManagement, String, XmlSerializer) 

    /**
     * Method writeExclusion
     * 
     * @param exclusion
     * @param serializer
     * @param tagName
     */
    private void writeExclusion(Exclusion exclusion, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( exclusion != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( exclusion.getArtifactId() != null )
            {
                serializer.startTag( NAMESPACE, "artifactId" ).text( exclusion.getArtifactId() ).endTag( NAMESPACE, "artifactId" );
            }
            if ( exclusion.getGroupId() != null )
            {
                serializer.startTag( NAMESPACE, "groupId" ).text( exclusion.getGroupId() ).endTag( NAMESPACE, "groupId" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeExclusion(Exclusion, String, XmlSerializer) 

    /**
     * Method writeFileSet
     * 
     * @param fileSet
     * @param serializer
     * @param tagName
     */
    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( fileSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( fileSet.getDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "directory" ).text( fileSet.getDirectory() ).endTag( NAMESPACE, "directory" );
            }
            if ( fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeFileSet(FileSet, String, XmlSerializer) 

    /**
     * Method writeGoal
     * 
     * @param goal
     * @param serializer
     * @param tagName
     */
    private void writeGoal(Goal goal, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( goal != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( goal.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( goal.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( goal.getConfiguration() != null )
            {
                ((Xpp3Dom) goal.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeGoal(Goal, String, XmlSerializer) 

    /**
     * Method writeIssueManagement
     * 
     * @param issueManagement
     * @param serializer
     * @param tagName
     */
    private void writeIssueManagement(IssueManagement issueManagement, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( issueManagement != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( issueManagement.getSystem() != null )
            {
                serializer.startTag( NAMESPACE, "system" ).text( issueManagement.getSystem() ).endTag( NAMESPACE, "system" );
            }
            if ( issueManagement.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( issueManagement.getUrl() ).endTag( NAMESPACE, "url" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeIssueManagement(IssueManagement, String, XmlSerializer) 

    /**
     * Method writeLicense
     * 
     * @param license
     * @param serializer
     * @param tagName
     */
    private void writeLicense(License license, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( license != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( license.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( license.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( license.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( license.getUrl() ).endTag( NAMESPACE, "url" );
            }
            if ( license.getDistribution() != null )
            {
                serializer.startTag( NAMESPACE, "distribution" ).text( license.getDistribution() ).endTag( NAMESPACE, "distribution" );
            }
            if ( license.getComments() != null )
            {
                serializer.startTag( NAMESPACE, "comments" ).text( license.getComments() ).endTag( NAMESPACE, "comments" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeLicense(License, String, XmlSerializer) 

    /**
     * Method writeMailingList
     * 
     * @param mailingList
     * @param serializer
     * @param tagName
     */
    private void writeMailingList(MailingList mailingList, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( mailingList != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( mailingList.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( mailingList.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( mailingList.getSubscribe() != null )
            {
                serializer.startTag( NAMESPACE, "subscribe" ).text( mailingList.getSubscribe() ).endTag( NAMESPACE, "subscribe" );
            }
            if ( mailingList.getUnsubscribe() != null )
            {
                serializer.startTag( NAMESPACE, "unsubscribe" ).text( mailingList.getUnsubscribe() ).endTag( NAMESPACE, "unsubscribe" );
            }
            if ( mailingList.getPost() != null )
            {
                serializer.startTag( NAMESPACE, "post" ).text( mailingList.getPost() ).endTag( NAMESPACE, "post" );
            }
            if ( mailingList.getArchive() != null )
            {
                serializer.startTag( NAMESPACE, "archive" ).text( mailingList.getArchive() ).endTag( NAMESPACE, "archive" );
            }
            if ( mailingList.getOtherArchives() != null && mailingList.getOtherArchives().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "otherArchives" );
                for ( Iterator iter = mailingList.getOtherArchives().iterator(); iter.hasNext(); )
                {
                    String otherArchive = (String) iter.next();
                    serializer.startTag( NAMESPACE, "otherArchive" ).text( otherArchive ).endTag( NAMESPACE, "otherArchive" );
                }
                serializer.endTag( NAMESPACE, "otherArchives" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeMailingList(MailingList, String, XmlSerializer) 

    /**
     * Method writeModel
     * 
     * @param model
     * @param serializer
     * @param tagName
     */
    private void writeModel(Model model, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( model != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( model.getParent() != null )
            {
                writeParent( model.getParent(), "parent", serializer );
            }
            if ( model.getModelVersion() != null )
            {
                serializer.startTag( NAMESPACE, "modelVersion" ).text( model.getModelVersion() ).endTag( NAMESPACE, "modelVersion" );
            }
            if ( model.getGroupId() != null )
            {
                serializer.startTag( NAMESPACE, "groupId" ).text( model.getGroupId() ).endTag( NAMESPACE, "groupId" );
            }
            if ( model.getArtifactId() != null )
            {
                serializer.startTag( NAMESPACE, "artifactId" ).text( model.getArtifactId() ).endTag( NAMESPACE, "artifactId" );
            }
            if ( model.getPackaging() != null && !model.getPackaging().equals( "jar" ) )
            {
                serializer.startTag( NAMESPACE, "packaging" ).text( model.getPackaging() ).endTag( NAMESPACE, "packaging" );
            }
            if ( model.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( model.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( model.getVersion() != null )
            {
                serializer.startTag( NAMESPACE, "version" ).text( model.getVersion() ).endTag( NAMESPACE, "version" );
            }
            if ( model.getDescription() != null )
            {
                serializer.startTag( NAMESPACE, "description" ).text( model.getDescription() ).endTag( NAMESPACE, "description" );
            }
            if ( model.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( model.getUrl() ).endTag( NAMESPACE, "url" );
            }
            if ( model.getIssueManagement() != null )
            {
                writeIssueManagement( model.getIssueManagement(), "issueManagement", serializer );
            }
            if ( model.getCiManagement() != null )
            {
                writeCiManagement( model.getCiManagement(), "ciManagement", serializer );
            }
            if ( model.getInceptionYear() != null )
            {
                serializer.startTag( NAMESPACE, "inceptionYear" ).text( model.getInceptionYear() ).endTag( NAMESPACE, "inceptionYear" );
            }
            if ( model.getMailingLists() != null && model.getMailingLists().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "mailingLists" );
                for ( Iterator iter = model.getMailingLists().iterator(); iter.hasNext(); )
                {
                    MailingList mailingList = (MailingList) iter.next();
                    writeMailingList( mailingList, "mailingList", serializer );
                }
                serializer.endTag( NAMESPACE, "mailingLists" );
            }
            if ( model.getDevelopers() != null && model.getDevelopers().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "developers" );
                for ( Iterator iter = model.getDevelopers().iterator(); iter.hasNext(); )
                {
                    Developer developer = (Developer) iter.next();
                    writeDeveloper( developer, "developer", serializer );
                }
                serializer.endTag( NAMESPACE, "developers" );
            }
            if ( model.getContributors() != null && model.getContributors().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "contributors" );
                for ( Iterator iter = model.getContributors().iterator(); iter.hasNext(); )
                {
                    Contributor contributor = (Contributor) iter.next();
                    writeContributor( contributor, "contributor", serializer );
                }
                serializer.endTag( NAMESPACE, "contributors" );
            }
            if ( model.getLicenses() != null && model.getLicenses().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "licenses" );
                for ( Iterator iter = model.getLicenses().iterator(); iter.hasNext(); )
                {
                    License license = (License) iter.next();
                    writeLicense( license, "license", serializer );
                }
                serializer.endTag( NAMESPACE, "licenses" );
            }
            if ( model.getScm() != null )
            {
                writeScm( model.getScm(), "scm", serializer );
            }
            if ( model.getOrganization() != null )
            {
                writeOrganization( model.getOrganization(), "organization", serializer );
            }
            if ( model.getBuild() != null )
            {
                writeBuild( model.getBuild(), "build", serializer );
            }
            if ( model.getProfiles() != null && model.getProfiles().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "profiles" );
                for ( Iterator iter = model.getProfiles().iterator(); iter.hasNext(); )
                {
                    Profile profile = (Profile) iter.next();
                    writeProfile( profile, "profile", serializer );
                }
                serializer.endTag( NAMESPACE, "profiles" );
            }
            if ( model.getModules() != null && model.getModules().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "modules" );
                for ( Iterator iter = model.getModules().iterator(); iter.hasNext(); )
                {
                    String module = (String) iter.next();
                    serializer.startTag( NAMESPACE, "module" ).text( module ).endTag( NAMESPACE, "module" );
                }
                serializer.endTag( NAMESPACE, "modules" );
            }
            if ( model.getRepositories() != null && model.getRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "repositories" );
                for ( Iterator iter = model.getRepositories().iterator(); iter.hasNext(); )
                {
                    Repository repository = (Repository) iter.next();
                    writeRepository( repository, "repository", serializer );
                }
                serializer.endTag( NAMESPACE, "repositories" );
            }
            if ( model.getPluginRepositories() != null && model.getPluginRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "pluginRepositories" );
                for ( Iterator iter = model.getPluginRepositories().iterator(); iter.hasNext(); )
                {
                    Repository repository = (Repository) iter.next();
                    writeRepository( repository, "pluginRepository", serializer );
                }
                serializer.endTag( NAMESPACE, "pluginRepositories" );
            }
            if ( model.getDependencies() != null && model.getDependencies().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "dependencies" );
                for ( Iterator iter = model.getDependencies().iterator(); iter.hasNext(); )
                {
                    Dependency dependency = (Dependency) iter.next();
                    writeDependency( dependency, "dependency", serializer );
                }
                serializer.endTag( NAMESPACE, "dependencies" );
            }
            if ( model.getReports() != null )
            {
                ((Xpp3Dom) model.getReports()).writeToSerializer( NAMESPACE, serializer );
            }
            if ( model.getReporting() != null )
            {
                writeReporting( model.getReporting(), "reporting", serializer );
            }
            if ( model.getDependencyManagement() != null )
            {
                writeDependencyManagement( model.getDependencyManagement(), "dependencyManagement", serializer );
            }
            if ( model.getDistributionManagement() != null )
            {
                writeDistributionManagement( model.getDistributionManagement(), "distributionManagement", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeModel(Model, String, XmlSerializer) 

    /**
     * Method writeModelBase
     * 
     * @param modelBase
     * @param serializer
     * @param tagName
     */
    private void writeModelBase(ModelBase modelBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( modelBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( modelBase.getModules() != null && modelBase.getModules().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "modules" );
                for ( Iterator iter = modelBase.getModules().iterator(); iter.hasNext(); )
                {
                    String module = (String) iter.next();
                    serializer.startTag( NAMESPACE, "module" ).text( module ).endTag( NAMESPACE, "module" );
                }
                serializer.endTag( NAMESPACE, "modules" );
            }
            if ( modelBase.getRepositories() != null && modelBase.getRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "repositories" );
                for ( Iterator iter = modelBase.getRepositories().iterator(); iter.hasNext(); )
                {
                    Repository repository = (Repository) iter.next();
                    writeRepository( repository, "repository", serializer );
                }
                serializer.endTag( NAMESPACE, "repositories" );
            }
            if ( modelBase.getPluginRepositories() != null && modelBase.getPluginRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "pluginRepositories" );
                for ( Iterator iter = modelBase.getPluginRepositories().iterator(); iter.hasNext(); )
                {
                    Repository repository = (Repository) iter.next();
                    writeRepository( repository, "pluginRepository", serializer );
                }
                serializer.endTag( NAMESPACE, "pluginRepositories" );
            }
            if ( modelBase.getDependencies() != null && modelBase.getDependencies().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "dependencies" );
                for ( Iterator iter = modelBase.getDependencies().iterator(); iter.hasNext(); )
                {
                    Dependency dependency = (Dependency) iter.next();
                    writeDependency( dependency, "dependency", serializer );
                }
                serializer.endTag( NAMESPACE, "dependencies" );
            }
            if ( modelBase.getReports() != null )
            {
                ((Xpp3Dom) modelBase.getReports()).writeToSerializer( NAMESPACE, serializer );
            }
            if ( modelBase.getReporting() != null )
            {
                writeReporting( modelBase.getReporting(), "reporting", serializer );
            }
            if ( modelBase.getDependencyManagement() != null )
            {
                writeDependencyManagement( modelBase.getDependencyManagement(), "dependencyManagement", serializer );
            }
            if ( modelBase.getDistributionManagement() != null )
            {
                writeDistributionManagement( modelBase.getDistributionManagement(), "distributionManagement", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeModelBase(ModelBase, String, XmlSerializer) 

    /**
     * Method writeNotifier
     * 
     * @param notifier
     * @param serializer
     * @param tagName
     */
    private void writeNotifier(Notifier notifier, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( notifier != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( notifier.getType() != null && !notifier.getType().equals( "mail" ) )
            {
                serializer.startTag( NAMESPACE, "type" ).text( notifier.getType() ).endTag( NAMESPACE, "type" );
            }
            if ( notifier.getAddress() != null )
            {
                serializer.startTag( NAMESPACE, "address" ).text( notifier.getAddress() ).endTag( NAMESPACE, "address" );
            }
            if ( notifier.getConfiguration() != null && notifier.getConfiguration().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "configuration" );
                for ( Iterator iter = notifier.getConfiguration().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) notifier.getConfiguration().get( key );
                    serializer.startTag( NAMESPACE, "" + key + "" ).text( value ).endTag( NAMESPACE, "" + key + "" );
                }
                serializer.endTag( NAMESPACE, "configuration" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeNotifier(Notifier, String, XmlSerializer) 

    /**
     * Method writeOrganization
     * 
     * @param organization
     * @param serializer
     * @param tagName
     */
    private void writeOrganization(Organization organization, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( organization != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( organization.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( organization.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( organization.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( organization.getUrl() ).endTag( NAMESPACE, "url" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeOrganization(Organization, String, XmlSerializer) 

    /**
     * Method writeParent
     * 
     * @param parent
     * @param serializer
     * @param tagName
     */
    private void writeParent(Parent parent, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( parent != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( parent.getArtifactId() != null )
            {
                serializer.startTag( NAMESPACE, "artifactId" ).text( parent.getArtifactId() ).endTag( NAMESPACE, "artifactId" );
            }
            if ( parent.getGroupId() != null )
            {
                serializer.startTag( NAMESPACE, "groupId" ).text( parent.getGroupId() ).endTag( NAMESPACE, "groupId" );
            }
            if ( parent.getVersion() != null )
            {
                serializer.startTag( NAMESPACE, "version" ).text( parent.getVersion() ).endTag( NAMESPACE, "version" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeParent(Parent, String, XmlSerializer) 

    /**
     * Method writePatternSet
     * 
     * @param patternSet
     * @param serializer
     * @param tagName
     */
    private void writePatternSet(PatternSet patternSet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( patternSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( patternSet.getIncludes() != null && patternSet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = patternSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( patternSet.getExcludes() != null && patternSet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = patternSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePatternSet(PatternSet, String, XmlSerializer) 

    /**
     * Method writePlugin
     * 
     * @param plugin
     * @param serializer
     * @param tagName
     */
    private void writePlugin(Plugin plugin, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( plugin != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( plugin.getGroupId() != null && !plugin.getGroupId().equals( "org.apache.maven.plugins" ) )
            {
                serializer.startTag( NAMESPACE, "groupId" ).text( plugin.getGroupId() ).endTag( NAMESPACE, "groupId" );
            }
            if ( plugin.getArtifactId() != null )
            {
                serializer.startTag( NAMESPACE, "artifactId" ).text( plugin.getArtifactId() ).endTag( NAMESPACE, "artifactId" );
            }
            if ( plugin.getVersion() != null )
            {
                serializer.startTag( NAMESPACE, "version" ).text( plugin.getVersion() ).endTag( NAMESPACE, "version" );
            }
            if ( plugin.getExecutions() != null && plugin.getExecutions().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "executions" );
                for ( Iterator iter = plugin.getExecutions().iterator(); iter.hasNext(); )
                {
                    PluginExecution pluginExecution = (PluginExecution) iter.next();
                    writePluginExecution( pluginExecution, "execution", serializer );
                }
                serializer.endTag( NAMESPACE, "executions" );
            }
            if ( plugin.getGoals() != null && plugin.getGoals().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "goals" );
                for ( Iterator iter = plugin.getGoals().iterator(); iter.hasNext(); )
                {
                    Goal goal = (Goal) iter.next();
                    writeGoal( goal, "goal", serializer );
                }
                serializer.endTag( NAMESPACE, "goals" );
            }
            if ( plugin.getInherited() != null )
            {
                serializer.startTag( NAMESPACE, "inherited" ).text( plugin.getInherited() ).endTag( NAMESPACE, "inherited" );
            }
            if ( plugin.getConfiguration() != null )
            {
                ((Xpp3Dom) plugin.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePlugin(Plugin, String, XmlSerializer) 

    /**
     * Method writePluginConfiguration
     * 
     * @param pluginConfiguration
     * @param serializer
     * @param tagName
     */
    private void writePluginConfiguration(PluginConfiguration pluginConfiguration, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( pluginConfiguration != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( pluginConfiguration.getPluginManagement() != null )
            {
                writePluginManagement( pluginConfiguration.getPluginManagement(), "pluginManagement", serializer );
            }
            if ( pluginConfiguration.getPlugins() != null && pluginConfiguration.getPlugins().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "plugins" );
                for ( Iterator iter = pluginConfiguration.getPlugins().iterator(); iter.hasNext(); )
                {
                    Plugin plugin = (Plugin) iter.next();
                    writePlugin( plugin, "plugin", serializer );
                }
                serializer.endTag( NAMESPACE, "plugins" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePluginConfiguration(PluginConfiguration, String, XmlSerializer) 

    /**
     * Method writePluginContainer
     * 
     * @param pluginContainer
     * @param serializer
     * @param tagName
     */
    private void writePluginContainer(PluginContainer pluginContainer, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( pluginContainer != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( pluginContainer.getPlugins() != null && pluginContainer.getPlugins().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "plugins" );
                for ( Iterator iter = pluginContainer.getPlugins().iterator(); iter.hasNext(); )
                {
                    Plugin plugin = (Plugin) iter.next();
                    writePlugin( plugin, "plugin", serializer );
                }
                serializer.endTag( NAMESPACE, "plugins" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePluginContainer(PluginContainer, String, XmlSerializer) 

    /**
     * Method writePluginExecution
     * 
     * @param pluginExecution
     * @param serializer
     * @param tagName
     */
    private void writePluginExecution(PluginExecution pluginExecution, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( pluginExecution != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( pluginExecution.getId() != null && !pluginExecution.getId().equals( "default" ) )
            {
                serializer.startTag( NAMESPACE, "id" ).text( pluginExecution.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( pluginExecution.getPhase() != null )
            {
                serializer.startTag( NAMESPACE, "phase" ).text( pluginExecution.getPhase() ).endTag( NAMESPACE, "phase" );
            }
            if ( pluginExecution.getGoals() != null && pluginExecution.getGoals().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "goals" );
                for ( Iterator iter = pluginExecution.getGoals().iterator(); iter.hasNext(); )
                {
                    String goal = (String) iter.next();
                    serializer.startTag( NAMESPACE, "goal" ).text( goal ).endTag( NAMESPACE, "goal" );
                }
                serializer.endTag( NAMESPACE, "goals" );
            }
            if ( pluginExecution.getInherited() != null )
            {
                serializer.startTag( NAMESPACE, "inherited" ).text( pluginExecution.getInherited() ).endTag( NAMESPACE, "inherited" );
            }
            if ( pluginExecution.getConfiguration() != null )
            {
                ((Xpp3Dom) pluginExecution.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePluginExecution(PluginExecution, String, XmlSerializer) 

    /**
     * Method writePluginManagement
     * 
     * @param pluginManagement
     * @param serializer
     * @param tagName
     */
    private void writePluginManagement(PluginManagement pluginManagement, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( pluginManagement != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( pluginManagement.getPlugins() != null && pluginManagement.getPlugins().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "plugins" );
                for ( Iterator iter = pluginManagement.getPlugins().iterator(); iter.hasNext(); )
                {
                    Plugin plugin = (Plugin) iter.next();
                    writePlugin( plugin, "plugin", serializer );
                }
                serializer.endTag( NAMESPACE, "plugins" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePluginManagement(PluginManagement, String, XmlSerializer) 

    /**
     * Method writeProfile
     * 
     * @param profile
     * @param serializer
     * @param tagName
     */
    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( profile != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( profile.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( profile.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( profile.getActivation() != null )
            {
                writeActivation( profile.getActivation(), "activation", serializer );
            }
            if ( profile.getBuild() != null )
            {
                writeBuildBase( profile.getBuild(), "build", serializer );
            }
            if ( profile.getProperties() != null && profile.getProperties().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "properties" );
                for ( Iterator iter = profile.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) profile.getProperties().get( key );
                    serializer.startTag( NAMESPACE, "" + key + "" ).text( value ).endTag( NAMESPACE, "" + key + "" );
                }
                serializer.endTag( NAMESPACE, "properties" );
            }
            if ( profile.getModules() != null && profile.getModules().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "modules" );
                for ( Iterator iter = profile.getModules().iterator(); iter.hasNext(); )
                {
                    String module = (String) iter.next();
                    serializer.startTag( NAMESPACE, "module" ).text( module ).endTag( NAMESPACE, "module" );
                }
                serializer.endTag( NAMESPACE, "modules" );
            }
            if ( profile.getRepositories() != null && profile.getRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "repositories" );
                for ( Iterator iter = profile.getRepositories().iterator(); iter.hasNext(); )
                {
                    Repository repository = (Repository) iter.next();
                    writeRepository( repository, "repository", serializer );
                }
                serializer.endTag( NAMESPACE, "repositories" );
            }
            if ( profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "pluginRepositories" );
                for ( Iterator iter = profile.getPluginRepositories().iterator(); iter.hasNext(); )
                {
                    Repository repository = (Repository) iter.next();
                    writeRepository( repository, "pluginRepository", serializer );
                }
                serializer.endTag( NAMESPACE, "pluginRepositories" );
            }
            if ( profile.getDependencies() != null && profile.getDependencies().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "dependencies" );
                for ( Iterator iter = profile.getDependencies().iterator(); iter.hasNext(); )
                {
                    Dependency dependency = (Dependency) iter.next();
                    writeDependency( dependency, "dependency", serializer );
                }
                serializer.endTag( NAMESPACE, "dependencies" );
            }
            if ( profile.getReports() != null )
            {
                ((Xpp3Dom) profile.getReports()).writeToSerializer( NAMESPACE, serializer );
            }
            if ( profile.getReporting() != null )
            {
                writeReporting( profile.getReporting(), "reporting", serializer );
            }
            if ( profile.getDependencyManagement() != null )
            {
                writeDependencyManagement( profile.getDependencyManagement(), "dependencyManagement", serializer );
            }
            if ( profile.getDistributionManagement() != null )
            {
                writeDistributionManagement( profile.getDistributionManagement(), "distributionManagement", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeProfile(Profile, String, XmlSerializer) 

    /**
     * Method writeReportPlugin
     * 
     * @param reportPlugin
     * @param serializer
     * @param tagName
     */
    private void writeReportPlugin(ReportPlugin reportPlugin, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( reportPlugin != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( reportPlugin.getGroupId() != null && !reportPlugin.getGroupId().equals( "org.apache.maven.plugins" ) )
            {
                serializer.startTag( NAMESPACE, "groupId" ).text( reportPlugin.getGroupId() ).endTag( NAMESPACE, "groupId" );
            }
            if ( reportPlugin.getArtifactId() != null )
            {
                serializer.startTag( NAMESPACE, "artifactId" ).text( reportPlugin.getArtifactId() ).endTag( NAMESPACE, "artifactId" );
            }
            if ( reportPlugin.getVersion() != null )
            {
                serializer.startTag( NAMESPACE, "version" ).text( reportPlugin.getVersion() ).endTag( NAMESPACE, "version" );
            }
            if ( reportPlugin.getInherited() != null )
            {
                serializer.startTag( NAMESPACE, "inherited" ).text( reportPlugin.getInherited() ).endTag( NAMESPACE, "inherited" );
            }
            if ( reportPlugin.getConfiguration() != null )
            {
                ((Xpp3Dom) reportPlugin.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
            }
            if ( reportPlugin.getReportSets() != null && reportPlugin.getReportSets().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "reportSets" );
                for ( Iterator iter = reportPlugin.getReportSets().iterator(); iter.hasNext(); )
                {
                    ReportSet reportSet = (ReportSet) iter.next();
                    writeReportSet( reportSet, "reportSet", serializer );
                }
                serializer.endTag( NAMESPACE, "reportSets" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeReportPlugin(ReportPlugin, String, XmlSerializer) 

    /**
     * Method writeReportSet
     * 
     * @param reportSet
     * @param serializer
     * @param tagName
     */
    private void writeReportSet(ReportSet reportSet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( reportSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( reportSet.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( reportSet.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( reportSet.getConfiguration() != null )
            {
                ((Xpp3Dom) reportSet.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
            }
            if ( reportSet.getInherited() != null )
            {
                serializer.startTag( NAMESPACE, "inherited" ).text( reportSet.getInherited() ).endTag( NAMESPACE, "inherited" );
            }
            if ( reportSet.getReports() != null && reportSet.getReports().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "reports" );
                for ( Iterator iter = reportSet.getReports().iterator(); iter.hasNext(); )
                {
                    String report = (String) iter.next();
                    serializer.startTag( NAMESPACE, "report" ).text( report ).endTag( NAMESPACE, "report" );
                }
                serializer.endTag( NAMESPACE, "reports" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeReportSet(ReportSet, String, XmlSerializer) 

    /**
     * Method writeReporting
     * 
     * @param reporting
     * @param serializer
     * @param tagName
     */
    private void writeReporting(Reporting reporting, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( reporting != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( reporting.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( reporting.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( reporting.getPlugins() != null && reporting.getPlugins().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "plugins" );
                for ( Iterator iter = reporting.getPlugins().iterator(); iter.hasNext(); )
                {
                    ReportPlugin reportPlugin = (ReportPlugin) iter.next();
                    writeReportPlugin( reportPlugin, "plugin", serializer );
                }
                serializer.endTag( NAMESPACE, "plugins" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeReporting(Reporting, String, XmlSerializer) 

    /**
     * Method writeRepository
     * 
     * @param repository
     * @param serializer
     * @param tagName
     */
    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( repository != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( repository.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( repository.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( repository.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( repository.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( repository.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( repository.getUrl() ).endTag( NAMESPACE, "url" );
            }
            if ( repository.getSnapshotPolicy() != null && !repository.getSnapshotPolicy().equals( "daily" ) )
            {
                serializer.startTag( NAMESPACE, "snapshotPolicy" ).text( repository.getSnapshotPolicy() ).endTag( NAMESPACE, "snapshotPolicy" );
            }
            if ( repository.getLayout() != null && !repository.getLayout().equals( "default" ) )
            {
                serializer.startTag( NAMESPACE, "layout" ).text( repository.getLayout() ).endTag( NAMESPACE, "layout" );
            }
            if ( repository.getChecksumPolicy() != null && !repository.getChecksumPolicy().equals( "warn" ) )
            {
                serializer.startTag( NAMESPACE, "checksumPolicy" ).text( repository.getChecksumPolicy() ).endTag( NAMESPACE, "checksumPolicy" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeRepository(Repository, String, XmlSerializer) 

    /**
     * Method writeResource
     * 
     * @param resource
     * @param serializer
     * @param tagName
     */
    private void writeResource(Resource resource, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( resource != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( resource.getTargetPath() != null )
            {
                serializer.startTag( NAMESPACE, "targetPath" ).text( resource.getTargetPath() ).endTag( NAMESPACE, "targetPath" );
            }
            if ( resource.getDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "directory" ).text( resource.getDirectory() ).endTag( NAMESPACE, "directory" );
            }
            if ( resource.getIncludes() != null && resource.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = resource.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( resource.getExcludes() != null && resource.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = resource.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeResource(Resource, String, XmlSerializer) 

    /**
     * Method writeScm
     * 
     * @param scm
     * @param serializer
     * @param tagName
     */
    private void writeScm(Scm scm, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( scm != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( scm.getConnection() != null )
            {
                serializer.startTag( NAMESPACE, "connection" ).text( scm.getConnection() ).endTag( NAMESPACE, "connection" );
            }
            if ( scm.getDeveloperConnection() != null )
            {
                serializer.startTag( NAMESPACE, "developerConnection" ).text( scm.getDeveloperConnection() ).endTag( NAMESPACE, "developerConnection" );
            }
            if ( scm.getTag() != null && !scm.getTag().equals( "HEAD" ) )
            {
                serializer.startTag( NAMESPACE, "tag" ).text( scm.getTag() ).endTag( NAMESPACE, "tag" );
            }
            if ( scm.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( scm.getUrl() ).endTag( NAMESPACE, "url" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeScm(Scm, String, XmlSerializer) 

    /**
     * Method writeSite
     * 
     * @param site
     * @param serializer
     * @param tagName
     */
    private void writeSite(Site site, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( site != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( site.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( site.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( site.getName() != null )
            {
                serializer.startTag( NAMESPACE, "name" ).text( site.getName() ).endTag( NAMESPACE, "name" );
            }
            if ( site.getUrl() != null )
            {
                serializer.startTag( NAMESPACE, "url" ).text( site.getUrl() ).endTag( NAMESPACE, "url" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeSite(Site, String, XmlSerializer) 

}
