/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class ReportPlugin.
 * 
 * @version $Revision$ $Date$
 */
public class ReportPlugin implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId = "org.apache.maven.plugins";

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field inherited
     */
    private String inherited;

    /**
     * Field configuration
     */
    private Object configuration;

    /**
     * Field reportSets
     */
    private java.util.List reportSets;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addReportSet
     * 
     * @param reportSet
     */
    public void addReportSet(ReportSet reportSet)
    {
        getReportSets().add( reportSet );
    } //-- void addReportSet(ReportSet) 

    /**
     * Method getArtifactId
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Method getConfiguration
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Method getGroupId
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Method getInherited
     */
    public String getInherited()
    {
        return this.inherited;
    } //-- String getInherited() 

    /**
     * Method getReportSets
     */
    public java.util.List getReportSets()
    {
        if ( this.reportSets == null )
        {
            this.reportSets = new java.util.ArrayList();
        }
        
        return this.reportSets;
    } //-- java.util.List getReportSets() 

    /**
     * Method getVersion
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method removeReportSet
     * 
     * @param reportSet
     */
    public void removeReportSet(ReportSet reportSet)
    {
        getReportSets().remove( reportSet );
    } //-- void removeReportSet(ReportSet) 

    /**
     * Method setArtifactId
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Method setConfiguration
     * 
     * @param configuration
     */
    public void setConfiguration(Object configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(Object) 

    /**
     * Method setGroupId
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Method setInherited
     * 
     * @param inherited
     */
    public void setInherited(String inherited)
    {
        this.inherited = inherited;
    } //-- void setInherited(String) 

    /**
     * Method setReportSets
     * 
     * @param reportSets
     */
    public void setReportSets(java.util.List reportSets)
    {
        this.reportSets = reportSets;
    } //-- void setReportSets(java.util.List) 

    /**
     * Method setVersion
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


    private Map reportSetMap = null;
    
    public void flushReportSetMap()
    {
        this.reportSetMap = null;
    }

    public Map getReportSetsAsMap()
    {
        if ( reportSetMap == null )
        {
            reportSetMap = new HashMap();
            if ( getReportSets() != null )
            {
                for ( Iterator i = getReportSets().iterator(); i.hasNext(); )
                {
                    ReportSet reportSet = (ReportSet) i.next();
                    reportSetMap.put( reportSet.getId(), reportSet );
                }
            }
        }
        
        return reportSetMap;
    }
    
    public String getKey()
    {
        return constructKey( groupId, artifactId );
    }

    public static String constructKey( String groupId, String artifactId )
    {
        return groupId + ":" + artifactId;
    }
    
    private boolean inheritanceApplied = true;
    
    public void unsetInheritanceApplied()
    {
        this.inheritanceApplied = false;
    }
    
    public boolean isInheritanceApplied()
    {
        return inheritanceApplied;
    }
          }
