/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.Properties;

/**
 * Class Profile.
 * 
 * @version $Revision$ $Date$
 */
public class Profile extends ModelBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field activation
     */
    private Activation activation;

    /**
     * Field build
     */
    private BuildBase build;

    /**
     * Field properties
     */
    private java.util.Properties properties;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addProperty
     * 
     * @param key
     * @param value
     */
    public void addProperty(String key, String value)
    {
        getProperties().put( key, value );
    } //-- void addProperty(String, String) 

    /**
     * Method getActivation
     */
    public Activation getActivation()
    {
        return this.activation;
    } //-- Activation getActivation() 

    /**
     * Method getBuild
     */
    public BuildBase getBuild()
    {
        return this.build;
    } //-- BuildBase getBuild() 

    /**
     * Method getId
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getProperties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }
        
        return this.properties;
    } //-- java.util.Properties getProperties() 

    /**
     * Method setActivation
     * 
     * @param activation
     */
    public void setActivation(Activation activation)
    {
        this.activation = activation;
    } //-- void setActivation(Activation) 

    /**
     * Method setBuild
     * 
     * @param build
     */
    public void setBuild(BuildBase build)
    {
        this.build = build;
    } //-- void setBuild(BuildBase) 

    /**
     * Method setId
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Method setProperties
     * 
     * @param properties
     */
    public void setProperties(java.util.Properties properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.Properties) 


    // We don't want this to be parseable...it's sort of 'hidden'
    // default source for this profile is in the pom itself.
    private String source = "pom";
    
    public void setSource( String source )
    {
        this.source = source;
    }
    
    public String getSource()
    {
        return source;
    }
    
    public String toString()
    {
        return "Profile {id: " + getId() + ", source: " + getSource() + "}";
    }
          }
