/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Plugin.
 * 
 * @version $Revision$ $Date$
 */
public class Plugin extends ConfigurationContainer 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId = "org.apache.maven.plugins";

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field executions
     */
    private java.util.List executions;

    /**
     * Field goals
     */
    private java.util.List goals;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExecution
     * 
     * @param pluginExecution
     */
    public void addExecution(PluginExecution pluginExecution)
    {
        getExecutions().add( pluginExecution );
    } //-- void addExecution(PluginExecution) 

    /**
     * Method addGoal
     * 
     * @param goal
     */
    public void addGoal(Goal goal)
    {
        getGoals().add( goal );
    } //-- void addGoal(Goal) 

    /**
     * Method getArtifactId
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Method getExecutions
     */
    public java.util.List getExecutions()
    {
        if ( this.executions == null )
        {
            this.executions = new java.util.ArrayList();
        }
        
        return this.executions;
    } //-- java.util.List getExecutions() 

    /**
     * Method getGoals
     */
    public java.util.List getGoals()
    {
        if ( this.goals == null )
        {
            this.goals = new java.util.ArrayList();
        }
        
        return this.goals;
    } //-- java.util.List getGoals() 

    /**
     * Method getGroupId
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Method getVersion
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method removeExecution
     * 
     * @param pluginExecution
     */
    public void removeExecution(PluginExecution pluginExecution)
    {
        getExecutions().remove( pluginExecution );
    } //-- void removeExecution(PluginExecution) 

    /**
     * Method removeGoal
     * 
     * @param goal
     */
    public void removeGoal(Goal goal)
    {
        getGoals().remove( goal );
    } //-- void removeGoal(Goal) 

    /**
     * Method setArtifactId
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Method setExecutions
     * 
     * @param executions
     */
    public void setExecutions(java.util.List executions)
    {
        this.executions = executions;
    } //-- void setExecutions(java.util.List) 

    /**
     * Method setGoals
     * 
     * @param goals
     */
    public void setGoals(java.util.List goals)
    {
        this.goals = goals;
    } //-- void setGoals(java.util.List) 

    /**
     * Method setGroupId
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Method setVersion
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


    private Map executionMap = null;
    
    public void flushExecutionMap()
    {
        this.executionMap = null;
    }

    public Map getExecutionsAsMap()
    {
        if ( executionMap == null )
        {
            executionMap = new HashMap();
            if ( getExecutions() != null )
            {
                for ( Iterator i = getExecutions().iterator(); i.hasNext(); )
                {
                    PluginExecution exec = (PluginExecution) i.next();
                    
                    if ( executionMap.containsKey( exec.getId() ) )
                    {
                        throw new IllegalStateException( "You cannot have two plugin executions with the same (or missing) <id/> elements.\nOffending execution\n\nId: \'" + exec.getId() + "\'\nPlugin:\'" + getKey() + "\'\n\n" );
                    }
                    
                    executionMap.put( exec.getId(), exec );
                }
            }
        }
        
        return executionMap;
    }
    
    public String getKey()
    {
        return constructKey( groupId, artifactId );
    }

    public static String constructKey( String groupId, String artifactId )
    {
        return groupId + ":" + artifactId;
    }

    /** @deprecated */
    private Map goalMap = null;
    /** @deprecated */
    public void flushGoalMap()
    {
        this.goalMap = null;
    }

    /** @deprecated */
    public Map getGoalsAsMap()
    {
        if ( goalMap == null )
        {
            goalMap = new HashMap();
            if ( goals != null )
            {
                for ( Iterator i = goals.iterator(); i.hasNext(); )
                {
                    Goal g = (Goal) i.next();
                    goalMap.put( g.getId(), g );
                }
            }
        }
        return goalMap;
    }
          }
