/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Dependency.
 * 
 * @version $Revision$ $Date$
 */
public class Dependency implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field type
     */
    private String type = "jar";

    /**
     * Field scope
     */
    private String scope = "compile";

    /**
     * Field exclusions
     */
    private java.util.List exclusions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclusion
     * 
     * @param exclusion
     */
    public void addExclusion(Exclusion exclusion)
    {
        getExclusions().add( exclusion );
    } //-- void addExclusion(Exclusion) 

    /**
     * Method getArtifactId
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Method getExclusions
     */
    public java.util.List getExclusions()
    {
        if ( this.exclusions == null )
        {
            this.exclusions = new java.util.ArrayList();
        }
        
        return this.exclusions;
    } //-- java.util.List getExclusions() 

    /**
     * Method getGroupId
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Method getScope
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope() 

    /**
     * Method getType
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Method getVersion
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method removeExclusion
     * 
     * @param exclusion
     */
    public void removeExclusion(Exclusion exclusion)
    {
        getExclusions().remove( exclusion );
    } //-- void removeExclusion(Exclusion) 

    /**
     * Method setArtifactId
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Method setExclusions
     * 
     * @param exclusions
     */
    public void setExclusions(java.util.List exclusions)
    {
        this.exclusions = exclusions;
    } //-- void setExclusions(java.util.List) 

    /**
     * Method setGroupId
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Method setScope
     * 
     * @param scope
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    } //-- void setScope(String) 

    /**
     * Method setType
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Method setVersion
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


            public String toString()
            {
                return groupId + "/" + type + "s:" + artifactId + "-" + version;
            }
          
            public String getId()
            {
                return groupId + ":" + artifactId + ":" + type + ":" + version;
            }
            
            public String getManagementKey()
            {
                return groupId + ":" + artifactId + ":" + type;
            }
          }
