/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.project.builder.ArtifactModelContainerFactory;
import org.apache.maven.project.builder.ExclusionModelContainerFactory;
import org.apache.maven.project.builder.IdModelContainerFactory;
import org.apache.maven.project.builder.PomTransformer;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.project.builder.profile.ProfileContext;
import org.apache.maven.shared.model.DataSourceException;
import org.apache.maven.shared.model.DomainModel;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelDataSource;
import org.apache.maven.shared.model.ModelMarshaller;
import org.apache.maven.shared.model.ModelProperty;
import org.apache.maven.shared.model.impl.DefaultModelDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenDomainModel
implements DomainModel {
    private final List<ModelProperty> modelProperties;
    private String eventHistory;
    private ArtifactBasicMetadata parentMetadata;

    public MavenDomainModel(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(bytes));
    }

    public MavenDomainModel(InputStream inputStream) throws IOException {
        this(ModelMarshaller.marshallXmlToModelProperties((InputStream)inputStream, (String)ProjectUri.baseUri, (Set)PomTransformer.URIS));
    }

    public MavenDomainModel(List<ModelProperty> modelProperties) throws IOException {
        if (modelProperties == null) {
            throw new IllegalArgumentException("modelProperties: null");
        }
        this.modelProperties = new ArrayList<ModelProperty>(modelProperties);
    }

    public boolean hasParent() {
        return this.getParentMetadata() != null;
    }

    public List<ArtifactBasicMetadata> getDependencyMetadata() throws DataSourceException {
        ArrayList<ArtifactBasicMetadata> metadatas = new ArrayList<ArtifactBasicMetadata>();
        DefaultModelDataSource source = new DefaultModelDataSource();
        source.init(this.modelProperties, Arrays.asList(new ArtifactModelContainerFactory(), new IdModelContainerFactory()));
        for (ModelContainer modelContainer : source.queryFor(ProjectUri.Dependencies.Dependency.xUri)) {
            metadatas.add(this.transformContainerToMetadata(modelContainer));
        }
        return metadatas;
    }

    public Collection<ModelContainer> getActiveProfileContainers(List<InterpolatorProperty> properties) throws DataSourceException {
        DefaultModelDataSource dataSource = new DefaultModelDataSource();
        dataSource.init(this.modelProperties, Arrays.asList(new ArtifactModelContainerFactory(), new IdModelContainerFactory()));
        return new ProfileContext((ModelDataSource)dataSource, properties).getActiveProfiles();
    }

    public ArtifactBasicMetadata getParentMetadata() {
        if (this.parentMetadata != null) {
            return this.copyArtifactBasicMetadata(this.parentMetadata);
        }
        String groupId = null;
        String artifactId = null;
        String version = null;
        for (ModelProperty mp : this.modelProperties) {
            if (mp.getUri().equals(ProjectUri.Parent.version)) {
                version = mp.getValue();
            } else if (mp.getUri().equals(ProjectUri.Parent.artifactId)) {
                artifactId = mp.getValue();
            } else if (mp.getUri().equals(ProjectUri.Parent.groupId)) {
                groupId = mp.getValue();
            }
            if (groupId == null || artifactId == null || version == null) continue;
            break;
        }
        if (groupId == null || artifactId == null || version == null) {
            return null;
        }
        this.parentMetadata = new ArtifactBasicMetadata();
        this.parentMetadata.setArtifactId(artifactId);
        this.parentMetadata.setVersion(version);
        this.parentMetadata.setGroupId(groupId);
        return this.copyArtifactBasicMetadata(this.parentMetadata);
    }

    private ArtifactBasicMetadata copyArtifactBasicMetadata(ArtifactBasicMetadata metadata) {
        ArtifactBasicMetadata amd = new ArtifactBasicMetadata();
        amd.setArtifactId(metadata.getArtifactId());
        amd.setGroupId(metadata.getGroupId());
        amd.setVersion(metadata.getVersion());
        return amd;
    }

    public String getEventHistory() {
        return this.eventHistory;
    }

    public void setEventHistory(String eventHistory) {
        if (eventHistory == null) {
            throw new IllegalArgumentException("eventHistory: null");
        }
        this.eventHistory = eventHistory;
    }

    public List<ModelProperty> getModelProperties() throws IOException {
        return new ArrayList<ModelProperty>(this.modelProperties);
    }

    private ArtifactBasicMetadata transformContainerToMetadata(ModelContainer container) throws DataSourceException {
        List modelProperties = container.getProperties();
        ArtifactBasicMetadata metadata = new ArtifactBasicMetadata();
        for (ModelProperty mp : modelProperties) {
            if (mp.getUri().equals(ProjectUri.Dependencies.Dependency.groupId)) {
                metadata.setGroupId(mp.getValue());
                continue;
            }
            if (mp.getUri().equals(ProjectUri.Dependencies.Dependency.artifactId)) {
                metadata.setArtifactId(mp.getValue());
                continue;
            }
            if (mp.getUri().equals(ProjectUri.Dependencies.Dependency.version)) {
                metadata.setVersion(mp.getValue());
                continue;
            }
            if (mp.getUri().equals(ProjectUri.Dependencies.Dependency.classifier)) {
                metadata.setClassifier(mp.getValue());
                continue;
            }
            if (mp.getUri().equals(ProjectUri.Dependencies.Dependency.scope)) {
                metadata.setScope(mp.getValue());
                continue;
            }
            if (mp.getUri().equals(ProjectUri.Dependencies.Dependency.type)) {
                metadata.setType(mp.getValue());
                continue;
            }
            if (!mp.getUri().equals(ProjectUri.Dependencies.Dependency.optional)) continue;
            metadata.setOptional(mp.getValue());
        }
        if (metadata.getScope() == null) {
            metadata.setScope("runtime");
        }
        DefaultModelDataSource dataSource = new DefaultModelDataSource();
        dataSource.init(container.getProperties(), Arrays.asList(new ArtifactModelContainerFactory(), new ExclusionModelContainerFactory()));
        ArrayList<ArtifactBasicMetadata> exclusions = new ArrayList<ArtifactBasicMetadata>();
        for (ModelContainer exclusion : dataSource.queryFor(ProjectUri.Dependencies.Dependency.Exclusions.Exclusion.xUri)) {
            ArtifactBasicMetadata meta = new ArtifactBasicMetadata();
            exclusions.add(meta);
            for (ModelProperty mp : exclusion.getProperties()) {
                if (mp.getUri().equals(ProjectUri.Dependencies.Dependency.Exclusions.Exclusion.artifactId)) {
                    meta.setArtifactId(mp.getValue());
                    continue;
                }
                if (!mp.getUri().equals(ProjectUri.Dependencies.Dependency.Exclusions.Exclusion.groupId)) continue;
                meta.setGroupId(mp.getValue());
            }
        }
        metadata.setExclusions(exclusions);
        return metadata;
    }
}

