/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.mercury.MavenDomainModel;
import org.apache.maven.mercury.MavenDomainModelFactory;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.builder.api.DependencyProcessor;
import org.apache.maven.mercury.builder.api.DependencyProcessorException;
import org.apache.maven.mercury.builder.api.MetadataReader;
import org.apache.maven.mercury.builder.api.MetadataReaderException;
import org.apache.maven.project.builder.ArtifactModelContainerFactory;
import org.apache.maven.project.builder.IdModelContainerFactory;
import org.apache.maven.project.builder.PomInterpolatorTag;
import org.apache.maven.project.builder.PomTransformer;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.shared.model.DomainModel;
import org.apache.maven.shared.model.DomainModelFactory;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelProperty;
import org.apache.maven.shared.model.ModelTransformer;
import org.apache.maven.shared.model.ModelTransformerContext;
import org.codehaus.plexus.component.annotations.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependencyProcessor.class, hint="maven")
public final class MavenDependencyProcessor
implements DependencyProcessor {
    public List<ArtifactBasicMetadata> getDependencies(ArtifactBasicMetadata bmd, MetadataReader mdReader, Map system, Map user) throws MetadataReaderException, DependencyProcessorException {
        if (bmd == null) {
            throw new IllegalArgumentException("bmd: null");
        }
        if (mdReader == null) {
            throw new IllegalArgumentException("mdReader: null");
        }
        ArrayList<InterpolatorProperty> interpolatorProperties = new ArrayList<InterpolatorProperty>();
        interpolatorProperties.add(new InterpolatorProperty("${mavenVersion}", "3.0-SNAPSHOT", PomInterpolatorTag.EXECUTION_PROPERTIES.name()));
        if (system != null) {
            interpolatorProperties.addAll(InterpolatorProperty.toInterpolatorProperties((Map)system, (String)PomInterpolatorTag.EXECUTION_PROPERTIES.name()));
        }
        if (user != null) {
            interpolatorProperties.addAll(InterpolatorProperty.toInterpolatorProperties((Map)user, (String)PomInterpolatorTag.USER_PROPERTIES.name()));
        }
        ArrayList<DomainModel> domainModels = new ArrayList<DomainModel>();
        try {
            byte[] superBytes = mdReader.readMetadata(bmd);
            if (superBytes == null || superBytes.length < 1) {
                throw new DependencyProcessorException("cannot read metadata for " + bmd.getGAV());
            }
            MavenDomainModel domainModel = new MavenDomainModel(superBytes);
            domainModels.add(domainModel);
            Collection<ModelContainer> activeProfiles = domainModel.getActiveProfileContainers(interpolatorProperties);
            for (ModelContainer mc : activeProfiles) {
                domainModels.add(new MavenDomainModel(MavenDependencyProcessor.transformProfiles(mc.getProperties())));
            }
            domainModels.addAll(MavenDependencyProcessor.getParentsOfDomainModel(domainModel, mdReader));
        }
        catch (IOException e) {
            throw new MetadataReaderException("Failed to create domain model. Message = " + e.getMessage());
        }
        PomTransformer transformer = new PomTransformer((DomainModelFactory)new MavenDomainModelFactory());
        ModelTransformerContext ctx = new ModelTransformerContext(Arrays.asList(new ArtifactModelContainerFactory(), new IdModelContainerFactory()));
        try {
            MavenDomainModel model = (MavenDomainModel)ctx.transform(domainModels, (ModelTransformer)transformer, (ModelTransformer)transformer, null, interpolatorProperties, null);
            return model.getDependencyMetadata();
        }
        catch (IOException e) {
            throw new MetadataReaderException("Unable to transform model");
        }
    }

    private static List<DomainModel> getParentsOfDomainModel(MavenDomainModel domainModel, MetadataReader mdReader) throws IOException, MetadataReaderException {
        ArrayList<DomainModel> domainModels = new ArrayList<DomainModel>();
        if (domainModel.hasParent()) {
            MavenDomainModel parentDomainModel = new MavenDomainModel(mdReader.readMetadata(domainModel.getParentMetadata()));
            domainModels.add(parentDomainModel);
            domainModels.addAll(MavenDependencyProcessor.getParentsOfDomainModel(parentDomainModel, mdReader));
        }
        return domainModels;
    }

    private static List<ModelProperty> transformProfiles(List<ModelProperty> modelProperties) {
        ArrayList<ModelProperty> properties = new ArrayList<ModelProperty>();
        for (ModelProperty mp : modelProperties) {
            if (!mp.getUri().startsWith(ProjectUri.Profiles.Profile.xUri) || mp.getUri().equals(ProjectUri.Profiles.Profile.id) || mp.getUri().startsWith(ProjectUri.Profiles.Profile.Activation.xUri)) continue;
            properties.add(new ModelProperty(mp.getUri().replace(ProjectUri.Profiles.Profile.xUri, ProjectUri.xUri), mp.getResolvedValue()));
        }
        return properties;
    }
}

