/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.PrintStream;
import org.apache.maven.cli.AbstractMavenTransferListener;
import org.apache.maven.repository.ArtifactTransferEvent;

class ConsoleMavenTransferListener
extends AbstractMavenTransferListener {
    public ConsoleMavenTransferListener(PrintStream out) {
        super(out);
    }

    protected void doProgress(ArtifactTransferEvent transferEvent) {
        long total = transferEvent.getResource().getContentLength();
        long complete = transferEvent.getTransferredBytes();
        if (total >= 1024L) {
            this.out.print(this.toKB(complete) + "/" + this.toKB(total) + " KB" + "\r");
        } else if (total >= 0L) {
            this.out.print(complete + "/" + total + " B" + "\r");
        } else if (complete >= 1024L) {
            this.out.print(this.toKB(complete) + " KB" + "\r");
        } else {
            this.out.print(complete + " B" + "\r");
        }
    }
}

